/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.impl.manual.ManualTotemA;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.commands.arguments.PlayerSuggestion;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.messenger.CommandMessengerService;
import com.deathmotion.totemguard.models.TotemPlayer;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import io.github.retrooper.packetevents.util.folia.TaskWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.bukkit.parser.PlayerParser;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.IntegerParser;

public final class CheckCommand
extends AbstractCommand {
    private final TotemGuard plugin;
    private final ConfigManager configManager;
    private final CommandMessengerService commandMessengerService;
    private final Material totemMaterial = Material.TOTEM_OF_UNDYING;
    private final ExpiringMap<UUID, Long> cooldownCache = ExpiringMap.builder().expiration(15L, TimeUnit.SECONDS).build();

    public CheckCommand(TotemGuard plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.commandMessengerService = plugin.getMessengerService().getCommandMessengerService();
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("check", Description.of((String)"Forces a player to re-totem"), new String[0]).required("target", PlayerParser.playerParser(), PlayerSuggestion.onlinePlayerSuggestions()).optional("duration", IntegerParser.integerParser((int)0, (int)5000)).permission(this.perm("Check")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        Checks.ManualTotemA settings;
        int checkDuration;
        Player target;
        CommandSender sender = (CommandSender)ctx.sender();
        if (this.isTargetOnCooldown(sender, target = (Player)ctx.getOrDefault("target", null), checkDuration = ((Integer)ctx.getOrDefault("duration", (Object)(settings = this.configManager.getChecks().getManualTotemA()).getCheckTime())).intValue())) {
            return;
        }
        TotemPlayer totemPlayer = this.plugin.getPlayerDataManager().getPlayer(target);
        if (totemPlayer == null) {
            sender.sendMessage(this.commandMessengerService.targetCannotBeChecked());
            return;
        }
        if (!this.isTargetInValidGameState(sender, target)) {
            return;
        }
        if (!this.doesTargetHaveTotem(sender, target)) {
            return;
        }
        PlayerInventory playerInventory = target.getInventory();
        ItemStack[] originalInventory = (ItemStack[])Arrays.stream(playerInventory.getContents()).map(item -> item == null ? null : item.clone()).toArray(ItemStack[]::new);
        double originalHealth = target.getHealth();
        int originalFoodLevel = target.getFoodLevel();
        float originalSaturation = target.getSaturation();
        ArrayList<PotionEffect> originalEffects = new ArrayList<PotionEffect>(target.getActivePotionEffects());
        this.prepareTargetForCheck(target, playerInventory);
        final UUID targetUUID = target.getUniqueId();
        double healthBeforeDamage = target.getHealth();
        final boolean[] damageApplied = new boolean[]{false};
        Listener damageListener = new Listener(){

            @EventHandler(priority=EventPriority.MONITOR)
            public void onDamage(EntityDamageEvent event) {
                if (!event.getEntity().getUniqueId().equals(targetUUID)) {
                    return;
                }
                if (!event.isCancelled() && event.getFinalDamage() > 0.0) {
                    damageApplied[0] = true;
                }
                EntityDamageEvent.getHandlerList().unregister((Listener)this);
            }
        };
        Bukkit.getPluginManager().registerEvents(damageListener, (Plugin)this.plugin);
        target.damage(healthBeforeDamage + 1000.0);
        if (!damageApplied[0]) {
            this.restorePlayerState(target, originalHealth, originalInventory, originalFoodLevel, originalSaturation, originalEffects);
            sender.sendMessage(this.commandMessengerService.targetNoDamage());
            return;
        }
        this.scheduleCheckTask(sender, target, totemPlayer, checkDuration, originalHealth, originalInventory, originalFoodLevel, originalSaturation, originalEffects);
    }

    private boolean isTargetInValidGameState(CommandSender sender, Player target) {
        if (target.getGameMode() != GameMode.SURVIVAL && target.getGameMode() != GameMode.ADVENTURE) {
            sender.sendMessage(this.commandMessengerService.playerNotInSurvival());
            return false;
        }
        if (target.isInvulnerable()) {
            sender.sendMessage(this.commandMessengerService.playerInvulnerable());
            return false;
        }
        return true;
    }

    private boolean doesTargetHaveTotem(CommandSender sender, Player target) {
        boolean hasTotem;
        PlayerInventory inventory = target.getInventory();
        boolean bl = hasTotem = inventory.getItemInMainHand().getType() == this.totemMaterial || inventory.getItemInOffHand().getType() == this.totemMaterial;
        if (!hasTotem) {
            sender.sendMessage(this.commandMessengerService.playerNoTotem());
            return false;
        }
        return true;
    }

    private boolean isTargetOnCooldown(CommandSender sender, Player target, long checkTime) {
        long totalCooldown;
        long lastExecutionTime;
        long elapsedTime;
        UUID targetUUID = target.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.cooldownCache.containsKey((Object)targetUUID) && (elapsedTime = currentTime - (lastExecutionTime = ((Long)this.cooldownCache.get((Object)targetUUID)).longValue())) < (totalCooldown = checkTime + 1000L)) {
            long remainingTime = totalCooldown - elapsedTime;
            sender.sendMessage(this.commandMessengerService.targetOnCooldown(remainingTime));
            return true;
        }
        this.cooldownCache.put((Object)targetUUID, (Object)currentTime);
        return false;
    }

    private void prepareTargetForCheck(Player target, PlayerInventory inventory) {
        boolean hasTotemInOffHand;
        ItemStack mainHandItem = inventory.getItemInMainHand();
        ItemStack offHandItem = inventory.getItemInOffHand();
        boolean hasTotemInMainHand = mainHandItem.getType() == this.totemMaterial;
        boolean bl = hasTotemInOffHand = offHandItem.getType() == this.totemMaterial;
        if (hasTotemInMainHand) {
            mainHandItem.setAmount(1);
        }
        if (hasTotemInOffHand) {
            offHandItem.setAmount(1);
        }
        if (hasTotemInMainHand && hasTotemInOffHand) {
            inventory.setItemInMainHand(null);
        }
        int mainHandSlot = inventory.getHeldItemSlot();
        for (int i = 0; i < 9; ++i) {
            if (i == mainHandSlot) continue;
            inventory.setItem(i, new ItemStack(this.totemMaterial));
            break;
        }
        target.setHealth(0.5);
    }

    private void scheduleCheckTask(CommandSender sender, Player target, TotemPlayer totemPlayer, long checkTime, double originalHealth, ItemStack[] originalInventory, int originalFoodLevel, float originalSaturation, Collection<PotionEffect> originalEffects) {
        TaskWrapper[] taskWrapper;
        long startTime = System.currentTimeMillis();
        PlayerInventory inventory = target.getInventory();
        taskWrapper = new TaskWrapper[]{FoliaScheduler.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, o -> {
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (elapsedTime >= checkTime) {
                Component checkFinishedMessage = this.commandMessengerService.targetPassedCheck(target.getName());
                if (this.configManager.getSettings().isAnnounceCheckCommand()) {
                    this.plugin.getAlertManager().sendMessage(checkFinishedMessage);
                } else {
                    sender.sendMessage(checkFinishedMessage);
                }
                this.restorePlayerState(target, originalHealth, originalInventory, originalFoodLevel, originalSaturation, originalEffects);
                taskWrapper[0].cancel();
                return;
            }
            if (inventory.getItemInOffHand().getType() == this.totemMaterial) {
                this.restorePlayerState(target, originalHealth, originalInventory, originalFoodLevel, originalSaturation, originalEffects);
                taskWrapper[0].cancel();
                totemPlayer.checkManager.getGenericCheck(ManualTotemA.class).handle(sender, elapsedTime, checkTime);
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS)};
    }

    private void restorePlayerState(Player player, double health, ItemStack[] inventoryContents, int foodLevel, float saturation, Collection<PotionEffect> effects) {
        FoliaScheduler.getEntityScheduler().run((Entity)player, (Plugin)this.plugin, o -> {
            player.setHealth(health);
            player.setFoodLevel(foodLevel);
            player.setSaturation(saturation);
            player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
            player.addPotionEffects(effects);
            player.getInventory().setContents(inventoryContents);
        }, null);
    }
}

