/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.commands.arguments.PlayerSuggestion;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.messenger.CommandMessengerService;
import com.deathmotion.totemguard.messenger.impl.ClearLogsMessageService;
import com.deathmotion.totemguard.util.MessageUtil;
import com.deathmotion.totemguard.util.PlayerUtil;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.StringParser;

public final class ClearLogsCommand
extends AbstractCommand {
    private final TotemGuard plugin;
    private final DatabaseProvider databaseProvider;
    private final CommandMessengerService commandMessengerService;
    private final ClearLogsMessageService clearLogsMessageService;

    public ClearLogsCommand(TotemGuard plugin) {
        this.plugin = plugin;
        this.databaseProvider = plugin.getDatabaseProvider();
        this.commandMessengerService = plugin.getMessengerService().getCommandMessengerService();
        this.clearLogsMessageService = plugin.getMessengerService().getClearLogsMessageService();
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("clearlogs", Description.of((String)"Clears the logs of a player"), new String[0]).required("target", StringParser.stringParser(), PlayerSuggestion.onlinePlayerSuggestions()).permission(this.perm("ClearLogs")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        CommandSender sender = (CommandSender)ctx.sender();
        String username = (String)ctx.get("target");
        sender.sendMessage(MessageUtil.getPrefix().append((Component)Component.text((String)(" Clearing logs for " + username + "..."), (TextColor)NamedTextColor.GRAY)));
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)this.plugin, o -> {
            long startTime = System.currentTimeMillis();
            OfflinePlayer offlinePlayer = PlayerUtil.getOfflinePlayer(username);
            if (!offlinePlayer.isOnline() && !offlinePlayer.hasPlayedBefore()) {
                sender.sendMessage(MessageUtil.getPrefix().append((Component)Component.text((String)" Player not found", (TextColor)NamedTextColor.RED)));
                return;
            }
            int deletedRecords = this.databaseProvider.getGenericService().eraseLogs(offlinePlayer.getUniqueId());
            if (deletedRecords == -1) {
                sender.sendMessage(this.commandMessengerService.noDatabasePlayerFound(username));
                return;
            }
            long loadTime = System.currentTimeMillis() - startTime;
            sender.sendMessage(this.clearLogsMessageService.logsCleared(deletedRecords, offlinePlayer.getName(), loadTime));
        });
    }
}

