/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.commands.arguments.PlayerSuggestion;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.database.entities.DatabaseAlert;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.database.entities.DatabasePunishment;
import com.deathmotion.totemguard.messenger.CommandMessengerService;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.models.impl.SafetyStatus;
import com.deathmotion.totemguard.util.MessageUtil;
import com.deathmotion.totemguard.util.PlayerUtil;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.StringParser;

public final class ProfileCommand
extends AbstractCommand {
    private final TotemGuard plugin;
    private final DatabaseProvider db;
    private final MessengerService messenger;
    private final CommandMessengerService cms;
    private final ZoneId zoneId;

    public ProfileCommand(TotemGuard plugin) {
        this.plugin = plugin;
        this.db = plugin.getDatabaseProvider();
        this.messenger = plugin.getMessengerService();
        this.cms = this.messenger.getCommandMessengerService();
        this.zoneId = ZoneId.systemDefault();
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("profile", Description.of((String)"Gets the profile of a player"), new String[0]).required("target", StringParser.stringParser(), PlayerSuggestion.onlinePlayerSuggestions()).permission(this.perm("Profile")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        CommandSender sender = (CommandSender)ctx.sender();
        String username = (String)ctx.get("target");
        sender.sendMessage(this.cms.loadingProfile(username));
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)this.plugin, o -> {
            try {
                long startTime = System.currentTimeMillis();
                OfflinePlayer offlinePlayer = PlayerUtil.getOfflinePlayer(username);
                if (!offlinePlayer.isOnline() && !offlinePlayer.hasPlayedBefore()) {
                    sender.sendMessage(MessageUtil.getPrefix().append((Component)Component.text((String)" Player not found", (TextColor)NamedTextColor.RED)));
                    return;
                }
                UUID uuid = offlinePlayer.getUniqueId();
                Instant dayStart = LocalDate.now(this.zoneId).atStartOfDay(this.zoneId).toInstant();
                String brand = this.db.getPlayerRepository().findByUuid(uuid).map(DatabasePlayer::getClientBrand).orElse("");
                long totalAlerts = this.db.getAlertRepository().countAlertsForPlayer(uuid);
                long totalPunishments = this.db.getPunishmentRepository().countPunishmentsForPlayer(uuid);
                long alertsToday = this.db.getAlertRepository().countAlertsSinceForPlayer(uuid, dayStart);
                List<DatabaseAlert> alerts = this.db.getAlertRepository().findRecentAlertsForPlayer(uuid, 20);
                List<DatabasePunishment> punishments = this.db.getPunishmentRepository().findRecentPunishmentsForPlayer(uuid, 20);
                long loadTime = System.currentTimeMillis() - startTime;
                SafetyStatus status = SafetyStatus.getSafetyStatus((int)alertsToday, (int)totalPunishments);
                sender.sendMessage(this.messenger.getProfileMessageService().createProfileMessage(username, brand, (int)totalAlerts, (int)totalPunishments, loadTime, status, alerts, punishments));
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to load profile: " + e.getMessage());
            }
        });
    }
}

