/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.messenger.impl.StatsMessageService;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;

public final class StatsCommand
extends AbstractCommand {
    private final TotemGuard plugin;
    private final DatabaseProvider databaseProvider;
    private final StatsMessageService statsMessageService;

    public StatsCommand(TotemGuard plugin) {
        this.plugin = plugin;
        this.databaseProvider = plugin.getDatabaseProvider();
        this.statsMessageService = plugin.getMessengerService().getStatsMessageService();
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("stats", Description.of((String)"Shows global stats"), new String[0]).permission(this.perm("Stats")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        CommandSender sender = (CommandSender)ctx.sender();
        sender.sendMessage(this.statsMessageService.statsLoading());
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            Instant now = Instant.now();
            Instant dayAgo = now.minus(1L, ChronoUnit.DAYS);
            Instant weekAgo = now.minus(7L, ChronoUnit.DAYS);
            Instant monthAgo = now.minus(30L, ChronoUnit.DAYS);
            ExecutorService dbExec = Executors.newFixedThreadPool(4);
            CompletableFuture<Long> totalPunishments = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getPunishmentRepository().countAllPunishments();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> punishments30 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getPunishmentRepository().countPunishmentsSince(monthAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> punishments7 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getPunishmentRepository().countPunishmentsSince(weekAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> punishments1 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getPunishmentRepository().countPunishmentsSince(dayAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> totalAlerts = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getAlertRepository().countAllAlerts();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> alerts30 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getAlertRepository().countAlertsSince(monthAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> alerts7 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getAlertRepository().countAlertsSince(weekAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture<Long> alerts1 = CompletableFuture.supplyAsync(() -> {
                try {
                    return this.databaseProvider.getAlertRepository().countAlertsSince(dayAgo);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, dbExec);
            CompletableFuture.allOf(totalPunishments, punishments30, punishments7, punishments1, totalAlerts, alerts30, alerts7, alerts1).whenComplete((__, ex) -> {
                if (ex != null) {
                    sender.sendMessage("\u00a7cFailed to load stats: " + ex.getCause().getMessage());
                } else {
                    sender.sendMessage(this.statsMessageService.stats(((Long)totalPunishments.join()).intValue(), ((Long)totalAlerts.join()).intValue(), ((Long)punishments30.join()).intValue(), ((Long)punishments7.join()).intValue(), ((Long)punishments1.join()).intValue(), ((Long)alerts30.join()).intValue(), ((Long)alerts7.join()).intValue(), ((Long)alerts1.join()).intValue()));
                }
                dbExec.shutdown();
            });
        });
    }
}

