/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.commands.impl.database;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.AbstractCommand;
import com.deathmotion.totemguard.commands.impl.database.util.ValidationHelper;
import com.deathmotion.totemguard.commands.impl.database.util.ValidationType;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.messenger.impl.DatabaseMessageService;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.parser.standard.IntegerParser;

public final class TrimCommand
extends AbstractCommand {
    private final TotemGuard plugin;
    private final DatabaseProvider databaseProvider;
    private final DatabaseMessageService databaseMessageService;
    private final ValidationHelper validationHelper;

    public TrimCommand(TotemGuard plugin) {
        this.plugin = plugin;
        this.databaseProvider = plugin.getDatabaseProvider();
        this.databaseMessageService = plugin.getMessengerService().getDatabaseMessageService();
        this.validationHelper = ValidationHelper.getInstance();
    }

    @Override
    public void register(LegacyPaperCommandManager<CommandSender> commandManager) {
        commandManager.command(this.root(commandManager).literal("database", Description.of((String)"Database related commands"), new String[0]).literal("trim", Description.of((String)"Clears the entire database"), new String[0]).optional("code", IntegerParser.integerParser()).permission(this.perm("Database.Trim")).handler(this::handle));
    }

    private void handle(@NonNull CommandContext<CommandSender> ctx) {
        CommandSender sender = (CommandSender)ctx.sender();
        Integer code = (Integer)ctx.getOrDefault("code", null);
        if (code == null) {
            sender.sendMessage(this.validationHelper.generateCodeMessage(ValidationType.TRIM));
            return;
        }
        if (!this.validationHelper.validateCode(code)) {
            sender.sendMessage(this.databaseMessageService.invalidConfirmationCode());
            return;
        }
        sender.sendMessage(this.databaseMessageService.trimmingStartedComponent());
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)this.plugin, o -> {
            long startTime = System.currentTimeMillis();
            int totalRemovedLogs = this.databaseProvider.getGenericService().optimizeDatabase();
            long loadTime = System.currentTimeMillis() - startTime;
            sender.sendMessage(this.databaseMessageService.trimmingCompleted(totalRemovedLogs, loadTime));
        });
    }
}

