/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.config;

import com.deathmotion.totemguard.interfaces.AbstractCheckSettings;
import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import java.util.List;
import lombok.Generated;

@Configuration
public class Checks {
    @Comment(value={"This command placeholder can be used by using %default_punishment% as a punishment command."})
    private String defaultPunishment = "ban %player% 1d [TotemGuard] Unfair Advantage";
    @Comment(value={"\nAutoTotemA"})
    private AutoTotemA autoTotemA = new AutoTotemA();
    @Comment(value={"\nAutoTotemB"})
    private AutoTotemB autoTotemB = new AutoTotemB();
    @Comment(value={"\nAutoTotemC"})
    private AutoTotemC autoTotemC = new AutoTotemC();
    @Comment(value={"\nAutoTotemD"})
    private AutoTotemD autoTotemD = new AutoTotemD();
    @Comment(value={"\nAutoTotemE"})
    private AutoTotemE autoTotemE = new AutoTotemE();
    @Comment(value={"\nAutoTotemF"})
    private AutoTotemF autoTotemF = new AutoTotemF();
    @Comment(value={"\nAutoTotemG"})
    private AutoTotemG autoTotemG = new AutoTotemG();
    @Comment(value={"\nBadPacketsA"})
    private BadPacketsA badPacketsA = new BadPacketsA();
    @Comment(value={"\nBadPacketsB"})
    private BadPacketsB badPacketsB = new BadPacketsB();
    @Comment(value={"\nBadPacketsC"})
    private BadPacketsC badPacketsC = new BadPacketsC();
    @Comment(value={"\nBadPacketsD"})
    private BadPacketsD badPacketsD = new BadPacketsD();
    @Comment(value={"\nManualTotemA"})
    private ManualTotemA manualTotemA = new ManualTotemA();
    @Comment(value={"\n\n======\n Mod Detections\n======\n\n Accurate Block Placement Reborn (https://modrinth.com/mod/accurate-block-placement-reborn)"})
    private AccurateBlockPlacement accurateBlockPlacementReborn = new AccurateBlockPlacement();

    public AbstractCheckSettings getCheckSettings(String checkName) {
        return switch (checkName) {
            case "AutoTotemA" -> this.autoTotemA;
            case "AutoTotemB" -> this.autoTotemB;
            case "AutoTotemC" -> this.autoTotemC;
            case "AutoTotemD" -> this.autoTotemD;
            case "AutoTotemE" -> this.autoTotemE;
            case "AutoTotemF" -> this.autoTotemF;
            case "AutoTotemG" -> this.autoTotemG;
            case "BadPacketsA" -> this.badPacketsA;
            case "BadPacketsB" -> this.badPacketsB;
            case "BadPacketsC" -> this.badPacketsC;
            case "BadPacketsD" -> this.badPacketsD;
            case "ManualTotemA" -> this.manualTotemA;
            case "AccurateBlockPlacement" -> this.accurateBlockPlacementReborn;
            default -> throw new IllegalStateException("Check " + checkName + " does not have a corresponding configuration.");
        };
    }

    @Generated
    public String getDefaultPunishment() {
        return this.defaultPunishment;
    }

    @Generated
    public AutoTotemA getAutoTotemA() {
        return this.autoTotemA;
    }

    @Generated
    public AutoTotemB getAutoTotemB() {
        return this.autoTotemB;
    }

    @Generated
    public AutoTotemC getAutoTotemC() {
        return this.autoTotemC;
    }

    @Generated
    public AutoTotemD getAutoTotemD() {
        return this.autoTotemD;
    }

    @Generated
    public AutoTotemE getAutoTotemE() {
        return this.autoTotemE;
    }

    @Generated
    public AutoTotemF getAutoTotemF() {
        return this.autoTotemF;
    }

    @Generated
    public AutoTotemG getAutoTotemG() {
        return this.autoTotemG;
    }

    @Generated
    public BadPacketsA getBadPacketsA() {
        return this.badPacketsA;
    }

    @Generated
    public BadPacketsB getBadPacketsB() {
        return this.badPacketsB;
    }

    @Generated
    public BadPacketsC getBadPacketsC() {
        return this.badPacketsC;
    }

    @Generated
    public BadPacketsD getBadPacketsD() {
        return this.badPacketsD;
    }

    @Generated
    public ManualTotemA getManualTotemA() {
        return this.manualTotemA;
    }

    @Generated
    public AccurateBlockPlacement getAccurateBlockPlacementReborn() {
        return this.accurateBlockPlacementReborn;
    }

    @Configuration
    public static class AutoTotemA
    extends CheckSettings {
        @Comment(value={"\nNormal Check Time: Sets the interval (in ms) for normal checks."})
        private int normalCheckTimeMs = 1500;
        @Comment(value={"\nClick Time Difference: The value (in ms) which anything below will trigger the flag."})
        private int clickTimeDifference = 75;

        public AutoTotemA() {
            super(true, 4);
        }

        @Generated
        public int getNormalCheckTimeMs() {
            return this.normalCheckTimeMs;
        }

        @Generated
        public int getClickTimeDifference() {
            return this.clickTimeDifference;
        }
    }

    @Configuration
    public static class AutoTotemB
    extends CheckSettings {
        @Comment(value={"\nStandard Deviation Threshold: The threshold for the standard deviation."})
        private double StandardDeviationThreshold = 30.0;
        @Comment(value={"\nMean Threshold: The threshold for the mean."})
        private double MeanThreshold = 500.0;
        @Comment(value={"\nConsecutive Low SD Count: The amount of consecutive low standard deviations before flagging."})
        private int ConsecutiveLowSDCount = 3;

        public AutoTotemB() {
            super(true, 12);
        }

        @Generated
        public double getStandardDeviationThreshold() {
            return this.StandardDeviationThreshold;
        }

        @Generated
        public double getMeanThreshold() {
            return this.MeanThreshold;
        }

        @Generated
        public int getConsecutiveLowSDCount() {
            return this.ConsecutiveLowSDCount;
        }
    }

    @Configuration
    public static class AutoTotemC
    extends CheckSettings {
        @Comment(value={"\nConsistent SD Range: The range for the standard average deviation."})
        private double ConsistentSDRange = 1.0;
        @Comment(value={"\nConsecutive Violations: The amount of consecutive violations before flagging."})
        private int ConsecutiveViolations = 3;

        public AutoTotemC() {
            super(false, 6);
        }

        @Generated
        public double getConsistentSDRange() {
            return this.ConsistentSDRange;
        }

        @Generated
        public int getConsecutiveViolations() {
            return this.ConsecutiveViolations;
        }
    }

    @Configuration
    public static class AutoTotemD
    extends CheckSettings {
        @Comment(value={"\nTotal Sequence: The total sequence timing under which the player will be flagged."})
        private int TotalSequence = 160;
        @Comment(value={"\nTime average Difference between packets: The time difference between packets."})
        private int BaseTimeDifference = 50;
        @Comment(value={"\nTime Tolerance: The tolerance for the time difference."})
        private int Tolerance = 5;

        public AutoTotemD() {
            super(true, 3);
        }

        @Generated
        public int getTotalSequence() {
            return this.TotalSequence;
        }

        @Generated
        public int getBaseTimeDifference() {
            return this.BaseTimeDifference;
        }

        @Generated
        public int getTolerance() {
            return this.Tolerance;
        }
    }

    @Configuration
    public static class AutoTotemE
    extends CheckSettings {
        @Comment(value={"\nStandard Deviation Threshold: The threshold for the standard deviation."})
        private double StandardDeviationThreshold = 10.0;
        @Comment(value={"\nAverage Standard Deviation Threshold: The threshold for the average standard deviation."})
        private double AverageStDeviationThreshold = 10.0;

        public AutoTotemE() {
            super(false, 4);
        }

        @Generated
        public double getStandardDeviationThreshold() {
            return this.StandardDeviationThreshold;
        }

        @Generated
        public double getAverageStDeviationThreshold() {
            return this.AverageStDeviationThreshold;
        }
    }

    @Configuration
    public static class AutoTotemF
    extends CheckSettings {
        @Comment(value={"\nTime Difference: The time difference between closing the inventory and the last click."})
        private int TimeDifference = 1500;

        public AutoTotemF() {
            super(false, 20);
        }

        @Generated
        public int getTimeDifference() {
            return this.TimeDifference;
        }
    }

    @Configuration
    public static class AutoTotemG
    extends CheckSettings {
        @Comment(value={"\nNormal Check Time: Sets the interval (in ms) for normal checks."})
        private int normalCheckTimeMs = 1500;
        @Comment(value={"\nClick to Swap Time Difference: The value (in ms) which anything below will trigger the flag."})
        private int clickToSwapTimeDifference = 75;

        public AutoTotemG() {
            super(false, 4);
        }

        @Generated
        public int getNormalCheckTimeMs() {
            return this.normalCheckTimeMs;
        }

        @Generated
        public int getClickToSwapTimeDifference() {
            return this.clickToSwapTimeDifference;
        }
    }

    @Configuration
    public static class BadPacketsA
    extends CheckSettings {
        public BadPacketsA() {
            super(true, 20, 1);
        }
    }

    @Configuration
    public static class BadPacketsB
    extends CheckSettings {
        @Comment(value={"\nBanned Client Brands: The list of client brands to flag."})
        private List<String> bannedBrands = List.of("autototem");

        public BadPacketsB() {
            super(true, 20, 1);
        }

        @Generated
        public List<String> getBannedBrands() {
            return this.bannedBrands;
        }
    }

    @Configuration
    public static class BadPacketsC
    extends CheckSettings {
        public BadPacketsC() {
            super(false, 20, 10);
        }
    }

    @Configuration
    public static class BadPacketsD
    extends CheckSettings {
        public BadPacketsD() {
            super(false, 20, 1);
        }
    }

    @Configuration
    public static class ManualTotemA
    extends CheckSettings {
        @Comment(value={"\nCheck Time: Amount of time the check command waits for a retotem. (in ms)"})
        private int CheckTime = 400;

        public ManualTotemA() {
            super(false, 4);
        }

        @Generated
        public int getCheckTime() {
            return this.CheckTime;
        }
    }

    @Configuration
    public static class AccurateBlockPlacement
    extends CheckSettings {
        public AccurateBlockPlacement() {
            super(false, 1, List.of("kick %player% [TotemGuard] Unauthorised Mod Detected"));
        }
    }

    @Configuration
    public static abstract class CheckSettings
    implements AbstractCheckSettings {
        private boolean enabled = true;
        private boolean punishable;
        private int punishmentDelayInSeconds = 0;
        private int maxViolations;
        private List<String> punishmentCommands = List.of("%default_punishment%");

        public CheckSettings(boolean punishable, int punishmentDelay, int maxViolations) {
            this.punishable = punishable;
            this.punishmentDelayInSeconds = punishmentDelay;
            this.maxViolations = maxViolations;
        }

        public CheckSettings(boolean punishable, int maxViolations, List<String> punishmentCommands) {
            this.punishable = punishable;
            this.maxViolations = maxViolations;
            this.punishmentCommands = List.copyOf(punishmentCommands == null ? List.of() : punishmentCommands);
        }

        public CheckSettings(boolean punishable, int maxViolations) {
            this.punishable = punishable;
            this.maxViolations = maxViolations;
        }

        @Override
        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        @Generated
        public boolean isPunishable() {
            return this.punishable;
        }

        @Override
        @Generated
        public int getPunishmentDelayInSeconds() {
            return this.punishmentDelayInSeconds;
        }

        @Override
        @Generated
        public int getMaxViolations() {
            return this.maxViolations;
        }

        @Override
        @Generated
        public List<String> getPunishmentCommands() {
            return this.punishmentCommands;
        }
    }
}

