/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.config;

import com.deathmotion.totemguard.util.Formatter;
import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import lombok.Generated;

@Configuration
public class Messages {
    @Comment(value={"Which text formatter to use (MINIMESSAGE, LEGACY)"})
    private Formatter format = Formatter.LEGACY;
    @Comment(value={"\nPrefix: The prefix for all messages."})
    private String prefix = "&6&lTG &8\u00bb";
    @Comment(value={"\nAlert Format: The format for all alerts."})
    private AlertFormat alertFormat = new AlertFormat();
    @Comment(value={""})
    private String alertsEnabled = "%prefix% &aAlerts enabled";
    private String alertsDisabled = "%prefix% &cAlerts disabled";
    private String alertsEnabledOther = "%prefix% &aAlerts enabled for %player%";
    private String alertsDisabledOther = "%prefix% &cAlerts disabled for %player%";
    private String noPermissionToggleOther = "%prefix% &cYou do not have permission to toggle alerts for other players.";
    private String alertToggleBlocked = "%prefix% &cAn external event handler is blocking your alert toggle.";
    private String alertBrand = "%prefix% &6%player% &7joined using: &6%client_brand%";
    @Comment(value={"\nCommand Messages"})
    private CommandMessages commandMessages = new CommandMessages();

    @Generated
    public Formatter getFormat() {
        return this.format;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public AlertFormat getAlertFormat() {
        return this.alertFormat;
    }

    @Generated
    public String getAlertsEnabled() {
        return this.alertsEnabled;
    }

    @Generated
    public String getAlertsDisabled() {
        return this.alertsDisabled;
    }

    @Generated
    public String getAlertsEnabledOther() {
        return this.alertsEnabledOther;
    }

    @Generated
    public String getAlertsDisabledOther() {
        return this.alertsDisabledOther;
    }

    @Generated
    public String getNoPermissionToggleOther() {
        return this.noPermissionToggleOther;
    }

    @Generated
    public String getAlertToggleBlocked() {
        return this.alertToggleBlocked;
    }

    @Generated
    public String getAlertBrand() {
        return this.alertBrand;
    }

    @Generated
    public CommandMessages getCommandMessages() {
        return this.commandMessages;
    }

    @Configuration
    public static class AlertFormat {
        @Comment(value={"Alert Format: The format for all alerts."})
        private String alertFormat = "%prefix% &e%player%&7 failed &6%check_name% &7VL[&6%violations%/%max_violations%&7]%dev%";
        @Comment(value={"\nAlert Format Console: The format for all alerts in console."})
        private String alertFormatConsole = "%prefix% &e%player%&7 failed &6%check_name% &7VL[&6%violations%/%max_violations%&7]%dev%";
        @Comment(value={"\nAlert Hover Format: The format for all alerts when hovered over."})
        private String alertHoverMessage = "&7TPS: &6%tps%&8 |&7 Client Version: &6%client_version%&8 |&7 Client Brand: &6%client_brand%\n\n&7Player: &6%player%\n&7Ping: &6(K: %k_ping%ms | T: %t_ping%ms)\n\n&7Check: &6%check_name%\n&7Description: &6%check_description%\n&7Server: &6%server%\n\n%check_details%\n\n&7Click to &6teleport &7to %player%.";
        @Comment(value={"\nAlert Click Command: The command to run when the alert is clicked."})
        private String alertClickCommand = "/tp %player%";
        @Comment(value={"\nPrefix for experimental checks. Replaces the %dev% placeholder."})
        private String devPrefix = "&d&l *";
        @Comment(value={"\nCheck Details Color: The color for the alert details."})
        private CheckDetailsColor checkDetailsColor = new CheckDetailsColor();

        @Generated
        public String getAlertFormat() {
            return this.alertFormat;
        }

        @Generated
        public String getAlertFormatConsole() {
            return this.alertFormatConsole;
        }

        @Generated
        public String getAlertHoverMessage() {
            return this.alertHoverMessage;
        }

        @Generated
        public String getAlertClickCommand() {
            return this.alertClickCommand;
        }

        @Generated
        public String getDevPrefix() {
            return this.devPrefix;
        }

        @Generated
        public CheckDetailsColor getCheckDetailsColor() {
            return this.checkDetailsColor;
        }

        @Configuration
        public static class CheckDetailsColor {
            @Comment(value={"Main Color: The main color for the check details."})
            private String main = "&7";
            @Comment(value={"\nSecondary Color: The secondary color for the check details."})
            private String secondary = "&6";

            @Generated
            public String getMain() {
                return this.main;
            }

            @Generated
            public String getSecondary() {
                return this.secondary;
            }
        }
    }

    @Configuration
    public static class CommandMessages {
        @Comment(value={"Generic Command Messages"})
        private GenericCommands genericCommands = new GenericCommands();
        @Comment(value={"\n/totemguard check"})
        private CheckCommand checkCommand = new CheckCommand();
        @Comment(value={"\n/totemguard profile"})
        private ProfileCommand profileCommand = new ProfileCommand();
        @Comment(value={"\n/totemguard database"})
        private DatabaseCommand databaseCommand = new DatabaseCommand();
        @Comment(value={"\n/totemguard clearlogs"})
        private ClearLogsCommand clearLogsCommand = new ClearLogsCommand();
        @Comment(value={"\n/totemguard stats"})
        private StatsCommand statsCommand = new StatsCommand();

        @Generated
        public GenericCommands getGenericCommands() {
            return this.genericCommands;
        }

        @Generated
        public CheckCommand getCheckCommand() {
            return this.checkCommand;
        }

        @Generated
        public ProfileCommand getProfileCommand() {
            return this.profileCommand;
        }

        @Generated
        public DatabaseCommand getDatabaseCommand() {
            return this.databaseCommand;
        }

        @Generated
        public ClearLogsCommand getClearLogsCommand() {
            return this.clearLogsCommand;
        }

        @Generated
        public StatsCommand getStatsCommand() {
            return this.statsCommand;
        }

        @Configuration
        public static class GenericCommands {
            private String specifyPlayer = "%prefix% &cPlease specify a player.";
            private String pluginReloaded = "%prefix% &aThe plugin has been reloaded!";
            private String targetNeverJoined = "%prefix% &cTarget has never joined the server.";
            private String noDatabasePlayerFound = "%prefix% &cNo database player found for %player%.";

            @Generated
            public String getSpecifyPlayer() {
                return this.specifyPlayer;
            }

            @Generated
            public String getPluginReloaded() {
                return this.pluginReloaded;
            }

            @Generated
            public String getTargetNeverJoined() {
                return this.targetNeverJoined;
            }

            @Generated
            public String getNoDatabasePlayerFound() {
                return this.noDatabasePlayerFound;
            }
        }

        @Configuration
        public static class CheckCommand {
            private String targetCannotBeChecked = "%prefix% &cTarget cannot be checked.";
            private String targetOnCooldown = "%prefix% &cTarget is on cooldown for %cooldown%ms.";
            private String playerNotSurvival = "%prefix% &cTarget must be in survival mode to use this command.";
            private String playerInvulnerable = "%prefix% &cTarget is invulnerable.";
            private String playerNoTotem = "%prefix% &cTarget does not have a totem in their hands.";
            private String targetNoDamage = "%prefix% &cTarget did not receive any damage. Are they protected by a plugin or in a safe zone?";
            private String targetPassed = "%prefix% &a%player% has successfully passed the manual check.";

            @Generated
            public String getTargetCannotBeChecked() {
                return this.targetCannotBeChecked;
            }

            @Generated
            public String getTargetOnCooldown() {
                return this.targetOnCooldown;
            }

            @Generated
            public String getPlayerNotSurvival() {
                return this.playerNotSurvival;
            }

            @Generated
            public String getPlayerInvulnerable() {
                return this.playerInvulnerable;
            }

            @Generated
            public String getPlayerNoTotem() {
                return this.playerNoTotem;
            }

            @Generated
            public String getTargetNoDamage() {
                return this.targetNoDamage;
            }

            @Generated
            public String getTargetPassed() {
                return this.targetPassed;
            }
        }

        @Configuration
        public static class ProfileCommand {
            private String loadingProfile = "%prefix% &7Loading profile for %player%...";
            @Comment(value={"\nProfile Format: The format for the message returned when checking a player's profile."})
            private ProfileFormat profileFormat = new ProfileFormat();

            @Generated
            public String getLoadingProfile() {
                return this.loadingProfile;
            }

            @Generated
            public ProfileFormat getProfileFormat() {
                return this.profileFormat;
            }

            @Configuration
            public static class ProfileFormat {
                private String profileFormat = "&6&lTotemGuard Profile\n&7&lPlayer: &6%player%\n&7&lBrand: &6%client_brand%\n&7&lSafety Status: %safety_status%\n&7&lTotal Alerts: &6%total_alerts%\n&7&lTotal Punishments: &6%total_punishments%\n&7&lLoad Time: &6%load_time%ms\n\n&6&l> Alert Summary <\n%alert_summary%\n\n&6&l> Punishment Summary <\n%punishment_summary%";
                @Comment(value={"\nProfile Alert Summary: The format for the alert summary in the profile. Will replace %alert_summary%."})
                private String alertSummary = "&8- &7&l%check_name% &6%violations%x";
                @Comment(value={"\nProfile Punishment Summary: The format for the punishment summary in the profile. Will replace %punishment_summary%."})
                private String punishmentSummary = "&8- &7Punished for &6&l%check_name% &7on &6%date%";
                @Comment(value={"\nProfile No Alerts Found: The message returned when no alerts are found. Will replace %alert_summary%."})
                private String noAlertsFound = "&7&o No alerts found.";
                @Comment(value={"\nProfile No Punishments Found: The message returned when no punishments are found. Will replace %punishment_summary%."})
                private String noPunishmentsFound = "&7&o No punishments found.";
                @Comment(value={"\nMessage to be added when more than 3 punishments are found."})
                private String showingLastPunishments = "&7&oShowing the last 3 punishments:";
                private String andMoreToBeDisplayed = "&7&o... and more not displayed";

                @Generated
                public String getProfileFormat() {
                    return this.profileFormat;
                }

                @Generated
                public String getAlertSummary() {
                    return this.alertSummary;
                }

                @Generated
                public String getPunishmentSummary() {
                    return this.punishmentSummary;
                }

                @Generated
                public String getNoAlertsFound() {
                    return this.noAlertsFound;
                }

                @Generated
                public String getNoPunishmentsFound() {
                    return this.noPunishmentsFound;
                }

                @Generated
                public String getShowingLastPunishments() {
                    return this.showingLastPunishments;
                }

                @Generated
                public String getAndMoreToBeDisplayed() {
                    return this.andMoreToBeDisplayed;
                }
            }
        }

        @Configuration
        public static class DatabaseCommand {
            @Comment(value={"Message when the database clearing has started."})
            private String clearingStarted = "%prefix% &aDatabase clearing started...";
            @Comment(value={"\nMessage when the database trimming has started."})
            private String trimmingStarted = "%prefix% &aDatabase trimming started...";
            @Comment(value={"\nInvalid confirmation code has been provided."})
            private String invalidConfirmationCode = "%prefix% &cInvalid code. Please use the code provided.";
            @Comment(value={"\nDatabase clearing completed"})
            private String clearingCompleted = "%prefix% &aCleared %amount% database entries in %duration%ms.";
            @Comment(value={"\nDatabase trimming completed"})
            private String trimmingCompleted = "%prefix% &aTrimmed %amount% database entries in %duration%ms.";
            @Comment(value={"\nAction Confirmation Format"})
            private ActionConfirmationFormat actionConfirmationFormat = new ActionConfirmationFormat();

            @Generated
            public String getClearingStarted() {
                return this.clearingStarted;
            }

            @Generated
            public String getTrimmingStarted() {
                return this.trimmingStarted;
            }

            @Generated
            public String getInvalidConfirmationCode() {
                return this.invalidConfirmationCode;
            }

            @Generated
            public String getClearingCompleted() {
                return this.clearingCompleted;
            }

            @Generated
            public String getTrimmingCompleted() {
                return this.trimmingCompleted;
            }

            @Generated
            public ActionConfirmationFormat getActionConfirmationFormat() {
                return this.actionConfirmationFormat;
            }

            @Configuration
            public static class ActionConfirmationFormat {
                private String actionConfirmationFormat = "&c&l[WARNING]: &7You are about to %action% the database.\n&7This action is irreversible.\n\n&7Type: %command%\n&7 or click %confirm_button% to confirm.";
                private String confirmButton = "&6&l[CONFIRM]";
                private String confirmHover = "&7Click to run %command%";
                private String confirmCommand = "/totemguard database %action% %code%";

                @Generated
                public String getActionConfirmationFormat() {
                    return this.actionConfirmationFormat;
                }

                @Generated
                public String getConfirmButton() {
                    return this.confirmButton;
                }

                @Generated
                public String getConfirmHover() {
                    return this.confirmHover;
                }

                @Generated
                public String getConfirmCommand() {
                    return this.confirmCommand;
                }
            }
        }

        @Configuration
        public static class ClearLogsCommand {
            @Comment(value={"Message when the logs are starting to get cleared."})
            private String clearingLogs = "%prefix% &7Clearing logs...";
            @Comment(value={"\nMessage when the logs have been cleared."})
            private String logsCleared = "%prefix% &aCleared %amount% logs for %player% in %duration%ms.";

            @Generated
            public String getClearingLogs() {
                return this.clearingLogs;
            }

            @Generated
            public String getLogsCleared() {
                return this.logsCleared;
            }
        }

        @Configuration
        public static class StatsCommand {
            @Comment(value={"Message when the stats are starting to get loaded."})
            private String loadingStats = "%prefix% &7Loading stats...";
            @Comment(value={"\nStats Format: The format for the message returned when checking the server stats."})
            private StatsFormat statsFormat = new StatsFormat();

            @Generated
            public String getLoadingStats() {
                return this.loadingStats;
            }

            @Generated
            public StatsFormat getStatsFormat() {
                return this.statsFormat;
            }

            @Configuration
            public static class StatsFormat {
                private String statsFormat = "&6&lTotemGuard Stats\n&7&lTotal Punishments: &6%total_punishments%\n&7&lTotal Alerts: &6%total_alerts%\n\n&6&l> Punishments <\n%punishment_summary%\n\n&6&l> Alerts <\n%alert_summary%";
                @Comment(value={"\nStats Punishment Summary: The format for the punishment summary in the stats. Will replace %punishment_summary%."})
                private String punishmentSummary = "&7&lLast 30 days: &6%punishment_last_30%\n&7&lLast 7 days: &6%punishment_last_7%\n&7&lLast 24 hours: &6%punishment_last_24h%";
                @Comment(value={"\nStats Alert Summary: The format for the alert summary in the stats. Will replace %alert_summary%."})
                private String alertSummary = "&7&lLast 30 days: &6%alerts_last_30%\n&7&lLast 7 days: &6%alerts_last_7%\n&7&lLast 24 hours: &6%alerts_last_24h%";
                @Comment(value={"\nStats No Punishments Found: The message returned when no punishments are found. Will replace %punishment_summary% if no punishments are found."})
                private String noPunishmentsFound = "&7&oNo punishments found.";
                @Comment(value={"\nStats No Alerts Found: The message returned when no alerts are found. Will replace %alert_summary% if no alerts are found."})
                private String noAlertsFound = "&7&oNo alerts found.";

                @Generated
                public String getStatsFormat() {
                    return this.statsFormat;
                }

                @Generated
                public String getPunishmentSummary() {
                    return this.punishmentSummary;
                }

                @Generated
                public String getAlertSummary() {
                    return this.alertSummary;
                }

                @Generated
                public String getNoPunishmentsFound() {
                    return this.noPunishmentsFound;
                }

                @Generated
                public String getNoAlertsFound() {
                    return this.noAlertsFound;
                }
            }
        }
    }
}

