/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.config;

import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import lombok.Generated;

@Configuration
public class Settings {
    @Comment(value={"API: Whether the API should be enabled."})
    private boolean api = true;
    @Comment(value={"\nServer Name: The name of the server. (Used for alerts, webhooks, API, etc.)"})
    private String server = "Default";
    @Comment(value={"\nName of the root command for TotemGuard. (This requires a server restart to take effect.)"})
    private String command = "totemguard";
    @Comment(value={"\nAlias for the root command. This allows using a shorter command. (Requires a server restart to take effect.)"})
    private String commandAlias = "tg";
    @Comment(value={"\nBypass: Whether players with the permission 'totemguard.bypass' can bypass checks."})
    private boolean bypass = false;
    @Comment(value={"\nConsole Alerts: Whether the console should receive alerts."})
    private boolean consoleAlerts = true;
    @Comment(value={"\nAnnounce client brand: Whether the client brand should be announced upon a player joining."})
    private boolean announceClientBrand = false;
    @Comment(value={"\nAnnounces that a player is being checked by a staff member using `/tg check <player>` for those with alerts enabled."})
    private boolean announceCheckCommand = true;
    @Comment(value={"\nRedis Configuration"})
    private Redis redis = new Redis();
    @Comment(value={"\nDatabase Settings:"})
    private Database database = new Database();
    @Comment(value={"\nUpdate Checker Settings:"})
    private UpdateChecker updateChecker = new UpdateChecker();
    @Comment(value={"\nDebug: Enables debug mode (Advanced Users Only)."})
    private boolean debug = false;

    @Generated
    public boolean isApi() {
        return this.api;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public String getCommandAlias() {
        return this.commandAlias;
    }

    @Generated
    public boolean isBypass() {
        return this.bypass;
    }

    @Generated
    public boolean isConsoleAlerts() {
        return this.consoleAlerts;
    }

    @Generated
    public boolean isAnnounceClientBrand() {
        return this.announceClientBrand;
    }

    @Generated
    public boolean isAnnounceCheckCommand() {
        return this.announceCheckCommand;
    }

    @Generated
    public Redis getRedis() {
        return this.redis;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setCommand(String command) {
        this.command = command;
    }

    @Generated
    public void setCommandAlias(String commandAlias) {
        this.commandAlias = commandAlias;
    }

    @Configuration
    public static class Redis {
        @Comment(value={"Enable and/or disable Redis."})
        private boolean enabled = false;
        @Comment(value={"\nSync Alerts: Whether alerts should be synced across servers."})
        private boolean syncAlerts = true;
        @Comment(value={"\nChannel: The redis channel the packets will be sent over."})
        private String channel = "totemguard";
        private String host = "localhost";
        private int port = 6379;
        private String username = "default";
        private String password = "yourPassword";

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isSyncAlerts() {
            return this.syncAlerts;
        }

        @Generated
        public String getChannel() {
            return this.channel;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }
    }

    @Configuration
    public static class Database {
        @Comment(value={"Database Type: The type of database to use. (h2, mysql, mariadb)"})
        private String Type = "h2";
        @Comment(value={"\nDatabase Host: The host of the database."})
        private String Host = "localhost";
        @Comment(value={"\nDatabase Port: The port of the database."})
        private int Port = 3306;
        @Comment(value={"\nDatabase Name: The name of the database."})
        private String Name = "TotemGuard";
        @Comment(value={"\nDatabase Username: The username of the database."})
        private String Username = "root";
        @Comment(value={"\nDatabase Password: The password of the database."})
        private String Password = "password";
        @Comment(value={"\nDatabase Connection Pool Size: The size of the connection pool."})
        private int connectionPoolSize = 4;

        @Generated
        public String getType() {
            return this.Type;
        }

        @Generated
        public String getHost() {
            return this.Host;
        }

        @Generated
        public int getPort() {
            return this.Port;
        }

        @Generated
        public String getName() {
            return this.Name;
        }

        @Generated
        public String getUsername() {
            return this.Username;
        }

        @Generated
        public String getPassword() {
            return this.Password;
        }

        @Generated
        public int getConnectionPoolSize() {
            return this.connectionPoolSize;
        }
    }

    @Configuration
    public static class UpdateChecker {
        @Comment(value={"Enable and/or disable the update checker."})
        private boolean enabled = true;
        @Comment(value={"\nPrint to Console: Prints the update message to the console."})
        private boolean printToConsole = true;
        @Comment(value={"\nNotify In-Game: Notifies players with the permission in-game."})
        private boolean notifyInGame = true;

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public boolean isPrintToConsole() {
            return this.printToConsole;
        }

        @Generated
        public boolean isNotifyInGame() {
            return this.notifyInGame;
        }
    }
}

