/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.config;

import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import lombok.Generated;

@Configuration
public class Webhooks {
    @Comment(value={"Webhook Alert Settings"})
    private AlertSettings alert = new AlertSettings();
    @Comment(value={"\nWebhook Punishment Settings"})
    private PunishmentSettings punishment = new PunishmentSettings();

    @Generated
    public AlertSettings getAlert() {
        return this.alert;
    }

    @Generated
    public PunishmentSettings getPunishment() {
        return this.punishment;
    }

    @Configuration
    public static class AlertSettings
    extends WebhookSettings {
        public AlertSettings() {
            super("TotemGuard Alert", "#d9b61a");
        }
    }

    @Configuration
    public static class PunishmentSettings
    extends WebhookSettings {
        public PunishmentSettings() {
            super("TotemGuard Punishment", "#d60010");
        }
    }

    @Configuration
    public static abstract class WebhookSettings {
        @Comment(value={"Enable and/or disable the webhook implementation."})
        private boolean enabled = false;
        @Comment(value={"\nWebhook URL: The URL of the webhook to send notifications to."})
        private String url = "https://discord.com/api/webhooks/your_webhook_url";
        @Comment(value={"\nClient Name: Name of the client."})
        private String name = "TotemGuard";
        @Comment(value={"\nWebhook Embed color: Color of the webhook embed (in hex)."})
        private String color;
        @Comment(value={"\nWebhook Title: Brief description about what the webhook is about. (Like Alert, Punishment, etc.)"})
        private String title;
        @Comment(value={"\nWebhook Profile Image: Sets the image of the embed's profile."})
        private String profileImage = "https://imgur.com/a/9IUVips";
        @Comment(value={"\nWebhook Timestamp: Displays the time that this embed was sent at."})
        private boolean timestamp = true;
        @Comment(value={"\nWebhook Footer: Sets the server name as the footer."})
        private boolean footer = true;

        public WebhookSettings(String title, String color) {
            this.title = title;
            this.color = color;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getColor() {
            return this.color;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getProfileImage() {
            return this.profileImage;
        }

        @Generated
        public boolean isTimestamp() {
            return this.timestamp;
        }

        @Generated
        public boolean isFooter() {
            return this.footer;
        }
    }
}

