/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.database;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Settings;
import com.deathmotion.totemguard.database.DatabaseService;
import com.deathmotion.totemguard.database.entities.DatabaseAlert;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.database.entities.DatabasePunishment;
import com.deathmotion.totemguard.database.repository.impl.AlertRepository;
import com.deathmotion.totemguard.database.repository.impl.PlayerRepository;
import com.deathmotion.totemguard.database.repository.impl.PunishmentRepository;
import com.j256.ormlite.db.BaseDatabaseType;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.jdbc.DataSourceConnectionSource;
import com.j256.ormlite.jdbc.db.H2DatabaseType;
import com.j256.ormlite.jdbc.db.MariaDbDatabaseType;
import com.j256.ormlite.jdbc.db.MysqlDatabaseType;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import lombok.Generated;

public final class DatabaseProvider {
    private final TotemGuard plugin;
    private HikariDataSource dataSource;
    private ConnectionSource connectionSource;
    private PlayerRepository playerRepository;
    private AlertRepository alertRepository;
    private PunishmentRepository punishmentRepository;
    private DatabaseService genericService;

    public DatabaseProvider(TotemGuard plugin) {
        this.plugin = plugin;
        this.init();
    }

    private void init() {
        Settings.Database cfg = this.plugin.getConfigManager().getSettings().getDatabase();
        this.dataSource = this.createDataSource(cfg);
        try {
            this.connectionSource = new DataSourceConnectionSource((DataSource)this.dataSource, (DatabaseType)this.getDatabaseType(cfg.getType()));
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize ConnectionSource", e);
        }
        try {
            Logger.setGlobalLogLevel((Level)Level.WARNING);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, DatabasePlayer.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, DatabaseAlert.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, DatabasePunishment.class);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.playerRepository = new PlayerRepository(this);
        this.alertRepository = new AlertRepository(this);
        this.punishmentRepository = new PunishmentRepository(this);
        this.genericService = new DatabaseService(this);
        this.plugin.getLogger().info("Database provider initialized");
    }

    public void reload() {
        this.close();
        this.init();
    }

    public void close() {
        try {
            if (this.connectionSource != null) {
                this.connectionSource.close();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(java.util.logging.Level.WARNING, "Error closing ConnectionSource", e);
        }
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    private HikariDataSource createDataSource(Settings.Database cfg) {
        String type;
        HikariConfig config = new HikariConfig();
        switch (type = cfg.getType().toLowerCase(Locale.ROOT)) {
            case "h2": {
                config.setDriverClassName("org.h2.Driver");
                break;
            }
            case "mysql": {
                config.setDriverClassName("com.mysql.cj.jdbc.Driver");
                break;
            }
            case "mariadb": {
                config.setDriverClassName("org.mariadb.jdbc.Driver");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported DB type: " + cfg.getType());
            }
        }
        config.setJdbcUrl(this.getJdbcUrl(cfg));
        config.setUsername(cfg.getUsername());
        config.setPassword(cfg.getPassword());
        config.setMaximumPoolSize(cfg.getConnectionPoolSize());
        config.setMinimumIdle(cfg.getConnectionPoolSize());
        config.setIdleTimeout(0L);
        config.setMaxLifetime(0L);
        return new HikariDataSource(config);
    }

    private String getJdbcUrl(Settings.Database cfg) {
        return switch (cfg.getType().toLowerCase(Locale.ROOT)) {
            case "h2" -> String.format("jdbc:h2:file:%s;DB_CLOSE_DELAY=-1", this.plugin.getDataFolder().getAbsolutePath() + "/db/data");
            case "mysql" -> String.format("jdbc:mysql://%s:%d/%s?autoReconnect=true&useSSL=false", cfg.getHost(), cfg.getPort(), cfg.getName());
            case "mariadb" -> String.format("jdbc:mariadb://%s:%d/%s?autoReconnect=true&useSSL=false", cfg.getHost(), cfg.getPort(), cfg.getName());
            default -> throw new IllegalArgumentException("Unsupported DB type: " + cfg.getType());
        };
    }

    private BaseDatabaseType getDatabaseType(String type) {
        return switch (type.toLowerCase(Locale.ROOT)) {
            case "h2" -> new H2DatabaseType();
            case "mysql" -> new MysqlDatabaseType();
            case "mariadb" -> new MariaDbDatabaseType();
            default -> throw new IllegalArgumentException("Unsupported DB type: " + type);
        };
    }

    @Generated
    public TotemGuard getPlugin() {
        return this.plugin;
    }

    @Generated
    public HikariDataSource getDataSource() {
        return this.dataSource;
    }

    @Generated
    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Generated
    public AlertRepository getAlertRepository() {
        return this.alertRepository;
    }

    @Generated
    public PunishmentRepository getPunishmentRepository() {
        return this.punishmentRepository;
    }

    @Generated
    public DatabaseService getGenericService() {
        return this.genericService;
    }
}

