/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.database;

import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.database.entities.DatabaseAlert;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.database.entities.DatabasePunishment;
import com.deathmotion.totemguard.database.repository.impl.AlertRepository;
import com.deathmotion.totemguard.database.repository.impl.PlayerRepository;
import com.deathmotion.totemguard.database.repository.impl.PunishmentRepository;
import com.deathmotion.totemguard.models.impl.ProfileData;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Blocking;

@Blocking
public class DatabaseService {
    private final PlayerRepository playerRepository;
    private final AlertRepository alertRepository;
    private final PunishmentRepository punishmentRepository;

    public DatabaseService(DatabaseProvider databaseProvider) {
        this.playerRepository = databaseProvider.getPlayerRepository();
        this.alertRepository = databaseProvider.getAlertRepository();
        this.punishmentRepository = databaseProvider.getPunishmentRepository();
    }

    public ProfileData retrieveProfileData(UUID uuid) {
        DatabasePlayer player = this.playerRepository.fetchOrCreatePlayer(uuid);
        if (player == null) {
            return null;
        }
        List<DatabaseAlert> alerts = this.alertRepository.findAlertsByPlayer(player);
        List<DatabasePunishment> punishments = this.punishmentRepository.findPunishmentsByPlayer(player);
        return new ProfileData(player.getClientBrand(), alerts, punishments);
    }

    public int eraseLogs(UUID uuid) {
        DatabasePlayer player = this.playerRepository.fetchOrCreatePlayer(uuid);
        if (player == null) {
            return -1;
        }
        int removedAlerts = this.alertRepository.deleteAlertsByPlayer(player);
        int removedPunishments = this.punishmentRepository.deletePunishmentsByPlayer(player);
        return removedAlerts + removedPunishments;
    }

    public int optimizeDatabase() {
        Instant cutoff = Instant.now().minusSeconds(2592000L);
        int oldAlerts = this.alertRepository.deleteAlertsOlderThan(cutoff);
        int oldPunishments = this.punishmentRepository.deletePunishmentsOlderThan(cutoff);
        return oldAlerts + oldPunishments;
    }

    @Blocking
    public int wipeDatabase() {
        int alertCount = this.alertRepository.deleteAllAlerts();
        int punishmentCount = this.punishmentRepository.deleteAllPunishments();
        int playersRemoved = this.playerRepository.deleteAllPlayers();
        return alertCount + punishmentCount + playersRemoved;
    }
}

