/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.database.repository;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Blocking;

@Blocking
public abstract class BaseRepository<T, ID> {
    protected final Dao<T, ID> dao;

    protected BaseRepository(ConnectionSource connectionSource, Class<T> clazz) {
        try {
            this.dao = DaoManager.createDao((ConnectionSource)connectionSource, clazz);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create DAO for " + clazz.getSimpleName(), e);
        }
    }

    protected QueryBuilder<T, ID> createQueryBuilder() {
        return this.dao.queryBuilder();
    }

    protected List<T> executeQuery(QueryBuilder<T, ID> queryBuilder) {
        try {
            return queryBuilder.query();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing query", e);
        }
    }

    public Optional<T> findById(ID id) {
        return this.execute(() -> Optional.ofNullable(this.dao.queryForId(id)));
    }

    public List<T> findAll() {
        return this.execute(() -> this.dao.queryForAll());
    }

    public boolean save(T entity) {
        return this.execute(() -> this.dao.createOrUpdate(entity).getNumLinesChanged() > 0);
    }

    public boolean delete(T entity) {
        return this.execute(() -> this.dao.delete(entity) > 0);
    }

    public boolean deleteById(ID id) {
        return this.execute(() -> this.dao.deleteById(id) > 0);
    }

    public long count() {
        return this.execute(() -> this.dao.countOf());
    }

    protected <R> R execute(SqlExecutor<R> executor) {
        try {
            return executor.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException("Database operation failed", e);
        }
    }

    @FunctionalInterface
    protected static interface SqlExecutor<R> {
        public R execute() throws SQLException;
    }
}

