/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.database.repository.impl;

import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.database.entities.DatabaseAlert;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.database.repository.BaseRepository;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class AlertRepository
extends BaseRepository<DatabaseAlert, UUID> {
    private static final String PLAYER_COLUMN = "totemguard_player_uuid";
    private static final String CREATION_TIMESTAMP_COLUMN = "when_created";
    private final DatabaseProvider databaseProvider;

    public AlertRepository(DatabaseProvider databaseProvider) {
        super(databaseProvider.getConnectionSource(), DatabaseAlert.class);
        this.databaseProvider = databaseProvider;
    }

    public void storeAlert(Check check) {
        DatabasePlayer dbPlayer = check.getPlayer().databasePlayer;
        if (dbPlayer == null) {
            dbPlayer = this.databaseProvider.getPlayerRepository().retrieveOrRefreshPlayer(check.getPlayer());
        }
        DatabaseAlert alert = new DatabaseAlert();
        alert.setCheckName(check.getCheckName());
        alert.setWhenCreated(Date.from(Instant.now()));
        alert.setPlayer(dbPlayer);
        this.save(alert);
    }

    public List<DatabaseAlert> findAlertsByPlayer(DatabasePlayer player) {
        return this.execute(() -> {
            QueryBuilder qb = this.createQueryBuilder();
            qb.where().eq(PLAYER_COLUMN, (Object)player.getUuid());
            return this.executeQuery(qb);
        });
    }

    public int deleteAlertsByPlayer(DatabasePlayer player) {
        return this.execute(() -> {
            DeleteBuilder db = this.dao.deleteBuilder();
            db.where().eq(PLAYER_COLUMN, (Object)player.getUuid());
            return db.delete();
        });
    }

    public int deleteAlertsOlderThan(Instant cutoff) {
        return this.execute(() -> {
            DeleteBuilder db = this.dao.deleteBuilder();
            db.where().lt(CREATION_TIMESTAMP_COLUMN, (Object)Date.from(cutoff));
            return db.delete();
        });
    }

    public int deleteAllAlerts() {
        return this.execute(() -> this.dao.deleteBuilder().delete());
    }

    public long countAllAlerts() throws SQLException {
        return this.dao.countOf();
    }

    public long countAlertsSince(Instant cutoff) throws SQLException {
        QueryBuilder qb = this.dao.queryBuilder();
        qb.setCountOf(true).where().ge(CREATION_TIMESTAMP_COLUMN, (Object)Date.from(cutoff));
        return this.dao.countOf(qb.prepare());
    }

    public long countAlertsForPlayer(UUID playerUuid) throws SQLException {
        QueryBuilder qb = this.dao.queryBuilder();
        qb.setCountOf(true).where().eq(PLAYER_COLUMN, (Object)playerUuid);
        return this.dao.countOf(qb.prepare());
    }

    public long countAlertsSinceForPlayer(UUID playerUuid, Instant cutoff) throws SQLException {
        QueryBuilder qb = this.dao.queryBuilder();
        qb.setCountOf(true).where().eq(PLAYER_COLUMN, (Object)playerUuid).and().ge(CREATION_TIMESTAMP_COLUMN, (Object)Date.from(cutoff));
        return this.dao.countOf(qb.prepare());
    }

    public List<DatabaseAlert> findRecentAlertsForPlayer(UUID playerUuid, int limit) throws SQLException {
        QueryBuilder qb = this.dao.queryBuilder();
        qb.where().eq(PLAYER_COLUMN, (Object)playerUuid);
        qb.orderBy(CREATION_TIMESTAMP_COLUMN, false);
        qb.limit(Long.valueOf(limit));
        return qb.query();
    }
}

