/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.database.repository.impl;

import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.database.repository.BaseRepository;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import java.util.Optional;
import java.util.UUID;

public class PlayerRepository
extends BaseRepository<DatabasePlayer, UUID> {
    private static final String PLAYER_UUID_COLUMN = "uuid";
    private final DatabaseProvider databaseProvider;

    public PlayerRepository(DatabaseProvider databaseProvider) {
        super(databaseProvider.getConnectionSource(), DatabasePlayer.class);
        this.databaseProvider = databaseProvider;
    }

    public Optional<DatabasePlayer> findByUuid(UUID uuid) {
        return this.execute(() -> {
            QueryBuilder qb = this.createQueryBuilder();
            qb.where().eq(PLAYER_UUID_COLUMN, (Object)uuid);
            return this.executeQuery(qb).stream().findFirst();
        });
    }

    public DatabasePlayer retrieveOrRefreshPlayer(TotemPlayer totemPlayer) {
        Optional<DatabasePlayer> found = this.findByUuid(totemPlayer.getUniqueId());
        if (found.isPresent()) {
            DatabasePlayer existing = found.get();
            existing.setClientBrand(totemPlayer.getBrand());
            this.save(existing);
            return existing;
        }
        DatabasePlayer newPlayer = new DatabasePlayer();
        newPlayer.setUuid(totemPlayer.getUniqueId());
        newPlayer.setClientBrand(totemPlayer.getBrand());
        this.save(newPlayer);
        return newPlayer;
    }

    public DatabasePlayer fetchOrCreatePlayer(UUID uuid) {
        return this.findByUuid(uuid).orElse(null);
    }

    public int deleteAllPlayers() {
        return this.execute(() -> {
            DeleteBuilder db = this.dao.deleteBuilder();
            return db.delete();
        });
    }
}

