/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.events.bukkit;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.models.impl.DigAndPickupState;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public class CheckManagerBukkitListener
implements Listener {
    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerChunkLoad(PlayerChunkLoadEvent event) {
        Player player = event.getPlayer();
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(player);
        if (totemPlayer == null) {
            return;
        }
        totemPlayer.runFirstChunkLoadedChecks();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerResurrect(EntityResurrectEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(player);
        if (totemPlayer == null) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType() != Material.TOTEM_OF_UNDYING) {
            totemPlayer.totemData.setLastTotemUsage(System.currentTimeMillis());
            totemPlayer.totemData.setExpectingTotemSwap(true);
            totemPlayer.digAndPickupState = new DigAndPickupState();
        }
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(player);
        if (totemPlayer == null) {
            return;
        }
        if (totemPlayer.totemData.isExpectingTotemSwap()) {
            ItemStack item = event.getCurrentItem();
            int hotbar = event.getHotbarButton();
            ItemStack hotbarItem = null;
            if (hotbar >= 0) {
                hotbarItem = player.getInventory().getItem(hotbar);
            }
            if (item != null && item.getType() == Material.TOTEM_OF_UNDYING || hotbarItem != null && hotbarItem.getType() == Material.TOTEM_OF_UNDYING) {
                this.callTotemCycleHandlers(totemPlayer);
            }
        }
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(player);
        if (totemPlayer == null) {
            return;
        }
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getPlayer());
        if (totemPlayer == null) {
            return;
        }
        if (totemPlayer.totemData.isExpectingTotemSwap() && event.getOffHandItem().getType() == Material.TOTEM_OF_UNDYING) {
            this.callTotemCycleHandlers(totemPlayer);
        }
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getEntity());
        if (totemPlayer == null) {
            return;
        }
        totemPlayer.totemData.setExpectingTotemSwap(false);
        totemPlayer.totemData.setLastTotemUsage(null);
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        TotemPlayer totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getPlayer());
        if (totemPlayer == null) {
            return;
        }
        totemPlayer.checkManager.onBukkitEvent((Event)event);
    }

    private void callTotemCycleHandlers(TotemPlayer player) {
        player.totemData.setExpectingTotemSwap(false);
        long currentTime = System.currentTimeMillis();
        Long lastUsage = player.totemData.getLastTotemUsage();
        long interval = Math.abs(currentTime - lastUsage);
        player.totemData.addInterval(interval);
        player.checkManager.onTotemCycleEvent();
    }
}

