/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.events.packets;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.PacketTypeSets;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.ConnectionState;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;

public class CheckManagerPacketListener
extends PacketListenerAbstract {
    public CheckManagerPacketListener() {
        super(PacketListenerPriority.LOW);
    }

    private static boolean isPlayerTriggeredPacket(PacketTypeCommon packetType) {
        return PacketTypeSets.PLAYER_TRIGGERED.contains(packetType);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        TotemPlayer player = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getConnectionState() != ConnectionState.PLAY) {
            if (event.getConnectionState() != ConnectionState.CONFIGURATION) {
                return;
            }
            player.checkManager.onPacketReceive(event);
            return;
        }
        if (CheckManagerPacketListener.isPlayerTriggeredPacket(event.getPacketType())) {
            player.runDelayedChecks();
        }
        player.checkManager.onPacketReceive(event);
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getConnectionState() != ConnectionState.PLAY) {
            return;
        }
        TotemPlayer player = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.BUNDLE) {
            player.sendingBundlePacket = !player.sendingBundlePacket;
        }
        player.checkManager.onPacketSend(event);
    }
}

