/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.events.packets;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPong;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientWindowConfirmation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPing;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerWindowConfirmation;

public class PacketPingListener
extends PacketListenerAbstract {
    private static final int UNSIGNED_SHORT_MASK = 65535;

    public PacketPingListener() {
        super(PacketListenerPriority.LOWEST);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        WrapperPlayClientWindowConfirmation wrapper;
        TotemPlayer player = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.WINDOW_CONFIRMATION) {
            wrapper = new WrapperPlayClientWindowConfirmation(event);
            int id = wrapper.getActionId() & 0xFFFF;
            player.pingData.addTransactionResponse(id);
        }
        if (event.getPacketType() == PacketType.Play.Client.PONG) {
            wrapper = new WrapperPlayClientPong(event);
            player.pingData.addTransactionResponse(wrapper.getId());
        }
    }

    public void onPacketSend(PacketSendEvent event) {
        WrapperPlayServerWindowConfirmation wrapper;
        TotemPlayer player = TotemGuard.getInstance().getPlayerDataManager().getPlayer(event.getUser());
        if (player == null) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Server.WINDOW_CONFIRMATION) {
            wrapper = new WrapperPlayServerWindowConfirmation(event);
            int id = wrapper.getActionId() & 0xFFFF;
            player.pingData.addTransactionSent(id);
        }
        if (event.getPacketType() == PacketType.Play.Server.PING) {
            wrapper = new WrapperPlayServerPing(event);
            player.pingData.addTransactionSent(wrapper.getId());
        }
    }
}

