/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.events.packets;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.event.UserDisconnectEvent;
import com.github.retrooper.packetevents.event.UserLoginEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.player.User;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketPlayerJoinQuit
extends PacketListenerAbstract {
    private final TotemGuard plugin;

    public PacketPlayerJoinQuit(TotemGuard plugin) {
        this.plugin = plugin;
    }

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() == PacketType.Login.Server.LOGIN_SUCCESS) {
            event.getTasksAfterSend().add(() -> TotemGuard.getInstance().getPlayerDataManager().addUser(event.getUser()));
        }
    }

    public void onUserLogin(UserLoginEvent event) {
        TotemPlayer totemPlayer;
        User user = event.getUser();
        if (user == null) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player.hasPermission("TotemGuard.Alerts") && player.hasPermission("TotemGuard.Alerts.EnableOnJoin")) {
            TotemGuard.getInstance().getAlertManager().toggleAlerts(player);
        }
        if (this.plugin.getConfigManager().getSettings().getUpdateChecker().isNotifyInGame() && this.plugin.getUpdateChecker().isUpdateAvailable() && player.hasPermission("TotemGuard.Update")) {
            FoliaScheduler.getAsyncScheduler().runDelayed((Plugin)this.plugin, o -> player.sendMessage(this.plugin.getUpdateChecker().getUpdateComponent()), 2L, TimeUnit.SECONDS);
        }
        if ((totemPlayer = TotemGuard.getInstance().getPlayerDataManager().getPlayer(user)) == null) {
            return;
        }
        totemPlayer.handlePlayerLogin(player);
    }

    public void onUserDisconnect(UserDisconnectEvent event) {
        TotemGuard.getInstance().getPlayerDataManager().remove(event.getUser());
        if (event.getUser().getProfile().getUUID() == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)event.getUser().getProfile().getUUID());
        if (player != null) {
            TotemGuard.getInstance().getAlertManager().handlePlayerQuit(player);
        }
    }
}

