/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.events.AlertsToggleEvent;
import com.deathmotion.totemguard.api.interfaces.AlertManager;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.database.DatabaseProvider;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.redis.packet.impl.SyncAlertMessagePacket;
import com.deathmotion.totemguard.util.datastructure.Pair;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AlertManagerImpl
implements AlertManager {
    private final ConcurrentHashMap<UUID, Player> enabledAlerts;
    private final TotemGuard plugin;
    private final DatabaseProvider databaseProvider;
    private final MessengerService messageService;

    public AlertManagerImpl(TotemGuard pluginInstance) {
        this.plugin = pluginInstance;
        this.databaseProvider = pluginInstance.getDatabaseProvider();
        this.messageService = pluginInstance.getMessengerService();
        this.enabledAlerts = new ConcurrentHashMap();
    }

    public void sendAlert(Check check, Component details) {
        Pair<Component, Component> craftedAlert = this.messageService.createAlert(check, details);
        this.enabledAlerts.values().forEach(player -> player.sendMessage((Component)craftedAlert.getX()));
        if (this.plugin.getConfigManager().getSettings().isConsoleAlerts()) {
            this.plugin.getServer().getConsoleSender().sendMessage(craftedAlert.getY());
        }
        this.plugin.getRedisService().publish(new SyncAlertMessagePacket(), new SyncAlertMessagePacket.AlertComponents(craftedAlert.getX(), craftedAlert.getY()));
        this.plugin.getDiscordManager().sendAlert(check, PlainTextComponentSerializer.plainText().serialize(details));
        this.databaseProvider.getAlertRepository().storeAlert(check);
    }

    public void sendAlert(SyncAlertMessagePacket.AlertComponents message) {
        if (this.plugin.getConfigManager().getSettings().isConsoleAlerts()) {
            this.plugin.getServer().getConsoleSender().sendMessage(message.consoleAlert);
        }
        this.enabledAlerts.values().forEach(player -> player.sendMessage(message.gameAlert));
    }

    public void sendMessage(Component message) {
        if (this.plugin.getConfigManager().getSettings().isConsoleAlerts()) {
            this.plugin.getServer().getConsoleSender().sendMessage(message);
        }
        this.enabledAlerts.values().forEach(player -> player.sendMessage(message));
    }

    @Override
    public boolean toggleAlerts(Player player) {
        boolean willEnable;
        UUID playerId = player.getUniqueId();
        boolean currentlyEnabled = this.enabledAlerts.containsKey(playerId);
        boolean bl = willEnable = !currentlyEnabled;
        if (!this.canToggleAlerts(player, willEnable)) {
            player.sendMessage(this.messageService.toggleAlertsBlockedExternal());
            return false;
        }
        if (currentlyEnabled) {
            this.enabledAlerts.remove(playerId);
            player.sendMessage(this.messageService.toggleAlerts(false));
        } else {
            this.enabledAlerts.put(playerId, player);
            player.sendMessage(this.messageService.toggleAlerts(true));
        }
        return true;
    }

    @Override
    public boolean enableAlerts(Player player) {
        UUID playerId = player.getUniqueId();
        if (this.enabledAlerts.containsKey(playerId)) {
            return true;
        }
        if (!this.canToggleAlerts(player, true)) {
            return false;
        }
        this.enabledAlerts.put(playerId, player);
        player.sendMessage(this.messageService.toggleAlerts(true));
        return true;
    }

    @Override
    public boolean hasAlertsEnabled(Player player) {
        return this.enabledAlerts.containsKey(player.getUniqueId());
    }

    public void handlePlayerQuit(Player player) {
        this.enabledAlerts.remove(player.getUniqueId());
    }

    private boolean canToggleAlerts(Player player, boolean enable) {
        if (!TotemGuard.getInstance().getConfigManager().getSettings().isApi()) {
            return true;
        }
        AlertsToggleEvent event = new AlertsToggleEvent(player, enable);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    @Generated
    public ConcurrentHashMap<UUID, Player> getEnabledAlerts() {
        return this.enabledAlerts;
    }
}

