/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.interfaces.AbstractCheck;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemA;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemB;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemC;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemD;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemE;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemF;
import com.deathmotion.totemguard.checks.impl.autototem.AutoTotemG;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsA;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsB;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsC;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsD;
import com.deathmotion.totemguard.checks.impl.manual.ManualTotemA;
import com.deathmotion.totemguard.checks.impl.misc.ClientBrand;
import com.deathmotion.totemguard.checks.impl.mods.AccurateBlockPlacement;
import com.deathmotion.totemguard.checks.type.BukkitEventCheck;
import com.deathmotion.totemguard.checks.type.GenericCheck;
import com.deathmotion.totemguard.checks.type.PacketCheck;
import com.deathmotion.totemguard.checks.type.SignCheck;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.concurrent.TimeUnit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class CheckManager {
    public ClassToInstanceMap<AbstractCheck> allChecks;
    ClassToInstanceMap<PacketCheck> packetChecks;
    ClassToInstanceMap<SignCheck> signChecks;
    ClassToInstanceMap<BukkitEventCheck> bukkitEventChecks;
    ClassToInstanceMap<GenericCheck> genericChecks;

    public CheckManager(TotemPlayer player) {
        this.packetChecks = new ImmutableClassToInstanceMap.Builder().put(ClientBrand.class, (Object)new ClientBrand(player)).put(BadPacketsA.class, (Object)new BadPacketsA(player)).put(BadPacketsC.class, (Object)new BadPacketsC(player)).put(AutoTotemD.class, (Object)new AutoTotemD(player)).build();
        this.signChecks = new ImmutableClassToInstanceMap.Builder().put(AccurateBlockPlacement.class, (Object)new AccurateBlockPlacement(player)).build();
        this.bukkitEventChecks = new ImmutableClassToInstanceMap.Builder().put(AutoTotemA.class, (Object)new AutoTotemA(player)).put(AutoTotemB.class, (Object)new AutoTotemB(player)).put(AutoTotemC.class, (Object)new AutoTotemC(player)).put(AutoTotemE.class, (Object)new AutoTotemE(player)).put(AutoTotemF.class, (Object)new AutoTotemF(player)).put(AutoTotemG.class, (Object)new AutoTotemG(player)).build();
        this.genericChecks = new ImmutableClassToInstanceMap.Builder().put(BadPacketsB.class, (Object)new BadPacketsB(player)).put(BadPacketsD.class, (Object)new BadPacketsD(player)).put(ManualTotemA.class, (Object)new ManualTotemA(player)).build();
        this.allChecks = new ImmutableClassToInstanceMap.Builder().putAll(this.packetChecks).putAll(this.bukkitEventChecks).putAll(this.genericChecks).build();
    }

    public void triggerSignChecks() {
        long delayMs = 0L;
        long ticksBetweenChecks = 2L;
        for (SignCheck check : this.signChecks.values()) {
            FoliaScheduler.getAsyncScheduler().runDelayed((Plugin)TotemGuard.getInstance(), o -> check.placeSign(), delayMs, TimeUnit.MILLISECONDS);
            delayMs += 100L;
        }
    }

    public void onPacketReceive(PacketReceiveEvent packet) {
        for (AbstractCheck check : this.packetChecks.values()) {
            check.onPacketReceive(packet);
        }
        for (AbstractCheck check : this.signChecks.values()) {
            check.onPacketReceive(packet);
        }
    }

    public void onPacketSend(PacketSendEvent packet) {
        for (PacketCheck check : this.packetChecks.values()) {
            check.onPacketSend(packet);
        }
    }

    public void onBukkitEvent(Event event) {
        for (BukkitEventCheck check : this.bukkitEventChecks.values()) {
            check.onBukkitEvent(event);
        }
    }

    public void onTotemCycleEvent() {
        for (BukkitEventCheck check : this.bukkitEventChecks.values()) {
            check.onTotemCycleEvent();
        }
    }

    public <T extends PacketCheck> T getPacketCheck(Class<T> check) {
        return (T)((PacketCheck)this.packetChecks.get(check));
    }

    public <T extends SignCheck> T getKeybindExploitCheck(Class<T> check) {
        return (T)((SignCheck)this.signChecks.get(check));
    }

    public <T extends BukkitEventCheck> T getBukkitEventCheck(Class<T> check) {
        return (T)((BukkitEventCheck)this.bukkitEventChecks.get(check));
    }

    public <T extends GenericCheck> T getGenericCheck(Class<T> check) {
        return (T)((GenericCheck)this.genericChecks.get(check));
    }
}

