/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.CommandBuilder;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.brigadier.BrigadierSetting;
import org.incendo.cloud.brigadier.CloudBrigadierManager;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;
import org.incendo.cloud.setting.Configurable;
import org.incendo.cloud.setting.Setting;
import org.jetbrains.annotations.NotNull;

public final class CloudCommandManager {
    @NotNull
    private final Logger log;
    @NotNull
    private final LegacyPaperCommandManager<CommandSender> commandManager;

    public CloudCommandManager(@NotNull TotemGuard plugin) {
        this.log = plugin.getLogger();
        this.commandManager = LegacyPaperCommandManager.createNative((Plugin)plugin, (ExecutionCoordinator)ExecutionCoordinator.simpleCoordinator());
        this.log.info(() -> "Initializing command manager...");
        this.configureCapabilities();
        this.registerCommands();
    }

    private void configureCapabilities() {
        if (this.commandManager.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            this.registerBrigadier();
        } else {
            this.log.info(() -> "Brigadier not available on this platform.");
            if (this.commandManager.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
                this.commandManager.registerAsynchronousCompletions();
                this.log.info(() -> "Asynchronous command completions enabled.");
            }
        }
    }

    private void registerBrigadier() {
        this.commandManager.registerBrigadier();
        CloudBrigadierManager brigadier = this.commandManager.brigadierManager();
        Configurable settings = brigadier.settings();
        settings.set((Setting)BrigadierSetting.FORCE_EXECUTABLE, true);
        this.log.info(() -> "Hooked into Brigadier for native command support.");
    }

    private void registerCommands() {
        new CommandBuilder(this.commandManager);
    }
}

