/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Checks;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.config.Settings;
import com.deathmotion.totemguard.config.Webhooks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.NameFormatters;
import de.exlll.configlib.YamlConfigurationProperties;
import de.exlll.configlib.YamlConfigurations;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Locale;
import java.util.logging.Level;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final TotemGuard plugin;
    private Settings settings;
    private Checks checks;
    private Messages messages;
    private Webhooks webhooks;

    public ConfigManager(TotemGuard plugin) {
        this.plugin = plugin;
        this.initializeConfig();
    }

    private void initializeConfig() {
        this.loadConfigurations();
    }

    public void reload() {
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)this.plugin, o -> {
            this.loadConfigurations();
            this.plugin.getDatabaseProvider().reload();
            this.plugin.getRedisService().reload();
            this.plugin.getDiscordManager().reload();
            for (TotemPlayer totemPlayer : TotemGuard.getInstance().getPlayerDataManager().getEntries()) {
                ChannelHelper.runInEventLoop((Object)totemPlayer.user.getChannel(), totemPlayer::reload);
            }
        });
    }

    private void loadConfigurations() {
        YamlConfigurationProperties properties = this.createYamlProperties();
        this.settings = this.loadConfigFile(this.getSettingsFile(), Settings.class, properties, "Failed to load config file");
        this.checks = this.loadConfigFile(this.getChecksFile(), Checks.class, properties, "Failed to load checks file");
        this.messages = this.loadConfigFile(this.getMessagesFile(), Messages.class, properties, "Failed to load messages file");
        this.webhooks = this.loadConfigFile(this.getWebhookFile(), Webhooks.class, properties, "Failed to load webhooks file");
        String cmd = this.settings.getCommand();
        if (!(cmd = cmd.toLowerCase(Locale.ROOT)).matches("[a-z]+")) {
            this.plugin.getLogger().severe("Invalid command '" + cmd + "'. It must consist of lowercase letters only. Please change it in the config.yml file. Falling back to default command 'totemguard'.");
            cmd = "totemguard";
        }
        this.settings.setCommand(cmd);
        String alias = this.settings.getCommandAlias();
        alias = alias.toLowerCase(Locale.ROOT);
        if (!alias.matches("[a-z]+")) {
            this.plugin.getLogger().severe("Invalid command alias '" + alias + "'. It must consist of lowercase letters only. Please change it in the config.yml file. Falling back to default alias 'tg'.");
            alias = "tg";
        }
        this.settings.setCommandAlias(alias);
    }

    private File getSettingsFile() {
        return new File(this.plugin.getDataFolder(), "config.yml");
    }

    private File getChecksFile() {
        return new File(this.plugin.getDataFolder(), "checks.yml");
    }

    private File getMessagesFile() {
        return new File(this.plugin.getDataFolder(), "messages.yml");
    }

    private File getWebhookFile() {
        return new File(this.plugin.getDataFolder(), "webhooks.yml");
    }

    private YamlConfigurationProperties createYamlProperties() {
        return ((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).setNameFormatter((NameFormatter)NameFormatters.LOWER_KEBAB_CASE)).outputNulls(false)).inputNulls(true)).header(this.createConfigHeader())).build();
    }

    private <T> T loadConfigFile(File file, Class<T> configClass, YamlConfigurationProperties properties, String errorMessage) {
        try {
            return (T)YamlConfigurations.update((Path)file.toPath(), configClass, (YamlConfigurationProperties)properties);
        }
        catch (Exception e) {
            this.logAndDisable(errorMessage, e);
            return null;
        }
    }

    private String createConfigHeader() {
        return "  ___________     __                   ________                       .___\n  \\__    ___/____/  |_  ____   _____  /  _____/ __ _______ _______  __| _/\n    |    | /  _ \\   __\\/ __ \\ /     \\/   \\  ___|  |  \\__  \\\\_  __ \\/ __ |\n    |    |(  <_> )  | \\  ___/|  Y Y  \\    \\_\\  \\  |  // __ \\|  | \\/ /_/ |\n    |____| \\____/|__|  \\___  >__|_|  /\\______  /____/(____  /__|  \\____ |\n                           \\/      \\/        \\/           \\/           \\/\n";
    }

    private void logAndDisable(String message, Exception e) {
        this.plugin.getLogger().log(Level.SEVERE, message, e);
        this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin);
    }

    @Generated
    public TotemGuard getPlugin() {
        return this.plugin;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public Checks getChecks() {
        return this.checks;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public Webhooks getWebhooks() {
        return this.webhooks;
    }
}

