/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.config.Webhooks;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.deathmotion.totemguard.util.TpsUtil;
import com.deathmotion.totemguard.util.webhook.Embed;
import com.deathmotion.totemguard.util.webhook.EmbedField;
import com.deathmotion.totemguard.util.webhook.EmbedFooter;
import com.deathmotion.totemguard.util.webhook.WebhookConfig;
import com.deathmotion.totemguard.util.webhook.WebhookMessage;
import java.awt.Color;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;

public class DiscordManager {
    private static final Predicate<String> WEBHOOK_REGEX = Pattern.compile("https://discord\\.com/api/webhooks/\\d+/[\\w-]+").asMatchPredicate();
    private static final int MAX_QUEUE_SIZE = 20;
    private static final Duration HTTP_TIMEOUT = Duration.ofSeconds(15L);
    private final TotemGuard plugin;
    private final HttpClient httpClient;
    private final ScheduledExecutorService scheduler;
    private final WebhookClient alertClient;
    private final WebhookClient punishmentClient;

    public DiscordManager(TotemGuard plugin) {
        this.plugin = plugin;
        this.httpClient = HttpClient.newBuilder().connectTimeout(HTTP_TIMEOUT).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "TotemGuard-DiscordWebhookProcessor"));
        Webhooks hooks = plugin.getConfigManager().getWebhooks();
        this.alertClient = new WebhookClient(this.loadConfig(hooks.getAlert()));
        this.punishmentClient = new WebhookClient(this.loadConfig(hooks.getPunishment()));
        this.alertClient.start();
        this.punishmentClient.start();
    }

    public void reload() {
        Webhooks hooks = this.plugin.getConfigManager().getWebhooks();
        this.alertClient.updateConfig(this.loadConfig(hooks.getAlert()));
        this.punishmentClient.updateConfig(this.loadConfig(hooks.getPunishment()));
    }

    public void sendAlert(Check check, String detailsPlain) {
        this.send(this.alertClient, check, detailsPlain, true);
    }

    public void sendPunishment(Check check, String detailsPlain) {
        this.send(this.punishmentClient, check, detailsPlain, false);
    }

    private void send(WebhookClient client, Check check, String detailsPlain, boolean isAlert) {
        if (!client.config.isValid()) {
            return;
        }
        TotemPlayer p = check.getPlayer();
        String violations = check.getCheckSettings().isPunishable() ? String.format("[%d/%d]", check.getViolations(), check.getMaxViolations()) : String.valueOf(check.getViolations());
        Embed embed = new Embed("").title(client.config.getTitle()).color(client.config.getColor()).thumbnailURL("https://crafthead.net/helm/" + String.valueOf(p.getUniqueId()));
        embed.addFields(new EmbedField("**Player**", "`" + p.getName() + "`", true), new EmbedField("**Check**", check.getCheckName(), true));
        if (isAlert) {
            embed.addFields(new EmbedField("**Violations**", violations, true), new EmbedField("**Brand**", p.getBrand(), true), new EmbedField("**Version**", p.user.getClientVersion().getReleaseName(), true), new EmbedField("**Ping**", "(K: " + p.getKeepAlivePing() + " | T: " + p.pingData.getTransactionPing() + ")", true), new EmbedField("**TPS**", String.format("%.2f", TpsUtil.getInstance().getTps(p.bukkitPlayer.getLocation())), true));
            if (!detailsPlain.isEmpty()) {
                embed.addFields(new EmbedField("**Details**", "```" + detailsPlain + "```", false));
            }
        }
        if (client.config.isTimestamp()) {
            embed.timestamp(Instant.now());
        }
        if (client.config.isFooter()) {
            embed.footer(new EmbedFooter("Server: " + this.plugin.getConfigManager().getSettings().getServer()));
        }
        WebhookMessage msg = new WebhookMessage().username(client.config.getUsername()).avatar(client.config.getAvatarUrl()).addEmbeds(embed);
        client.enqueue(this.buildRequest(msg, client.config.getUri()));
    }

    private HttpRequest buildRequest(WebhookMessage message, URI uri) {
        return HttpRequest.newBuilder().uri(uri).header("Content-Type", "application/json").timeout(HTTP_TIMEOUT).POST(HttpRequest.BodyPublishers.ofString(message.toJson().toString())).build();
    }

    private WebhookConfig loadConfig(Webhooks.WebhookSettings src) {
        WebhookConfig cfg = new WebhookConfig();
        if (!src.isEnabled()) {
            return cfg;
        }
        String url = src.getUrl();
        if (!WEBHOOK_REGEX.test(url)) {
            this.plugin.getLogger().warning("Invalid webhook URL: " + url);
            return cfg;
        }
        try {
            cfg.setUri(new URI(url));
            cfg.setUsername(src.getName());
            cfg.setAvatarUrl(src.getProfileImage());
            cfg.setTitle(src.getTitle());
            cfg.setColor(Color.decode(src.getColor()).getRGB());
            cfg.setTimestamp(src.isTimestamp());
            cfg.setFooter(src.isFooter());
            cfg.setValid(true);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse webhook settings: " + e.getMessage());
        }
        return cfg;
    }

    private class WebhookClient {
        private final LinkedBlockingDeque<HttpRequest> queue = new LinkedBlockingDeque(20);
        private final AtomicBoolean sending = new AtomicBoolean(false);
        private final AtomicLong rateLimitedUntil = new AtomicLong(0L);
        private final AtomicBoolean started = new AtomicBoolean(false);
        private WebhookConfig config;

        WebhookClient(WebhookConfig initial) {
            this.config = initial;
        }

        void updateConfig(WebhookConfig newCfg) {
            this.config = newCfg;
            this.queue.clear();
        }

        void enqueue(HttpRequest req) {
            if (!this.queue.offerLast(req)) {
                this.queue.pollFirst();
                this.queue.offerLast(req);
                DiscordManager.this.plugin.getLogger().warning("Discord queue full. Dropped oldest request.");
            }
        }

        void start() {
            if (this.started.compareAndSet(false, true)) {
                DiscordManager.this.scheduler.scheduleAtFixedRate(this::processQueue, 0L, 1L, TimeUnit.SECONDS);
            }
        }

        private void processQueue() {
            long now = System.currentTimeMillis();
            if (now < this.rateLimitedUntil.get()) {
                return;
            }
            if (!this.sending.compareAndSet(false, true)) {
                return;
            }
            HttpRequest req = this.queue.peekFirst();
            if (req == null) {
                this.sending.set(false);
                return;
            }
            DiscordManager.this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).whenComplete((resp, err) -> {
                try {
                    if (err != null) {
                        DiscordManager.this.plugin.getLogger().warning("Webhook send failed: " + err.getMessage());
                    } else if (resp.statusCode() == 429) {
                        resp.headers().firstValue("X-RateLimit-Reset").ifPresent(r -> this.rateLimitedUntil.set(Long.parseLong(r) * 1000L));
                    } else if (resp.statusCode() >= 400) {
                        DiscordManager.this.plugin.getLogger().warning("Discord webhook error " + resp.statusCode() + ": " + (String)resp.body());
                    }
                }
                finally {
                    if (err != null || resp == null || resp.statusCode() != 429) {
                        this.queue.pollFirst();
                    }
                    this.sending.set(false);
                }
            });
        }

        @Generated
        public WebhookConfig getConfig() {
            return this.config;
        }
    }
}

