/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.netty.channel.ChannelHelper;
import com.github.retrooper.packetevents.protocol.player.User;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final TotemGuard plugin;
    private final ConcurrentHashMap<User, TotemPlayer> playerDataMap = new ConcurrentHashMap();

    public PlayerDataManager(TotemGuard plugin) {
        this.plugin = plugin;
    }

    public boolean shouldCheck(User user, Player bukkitPlayer) {
        if (!ChannelHelper.isOpen((Object)user.getChannel())) {
            return false;
        }
        if (user.getUUID() == null) {
            return false;
        }
        if (this.plugin.getConfigManager().getSettings().isBypass() && bukkitPlayer != null && bukkitPlayer.hasPermission("TotemGuard.Bypass")) {
            return false;
        }
        return user.getUUID().getMostSignificantBits() != 0L;
    }

    @Nullable
    public TotemPlayer getPlayer(User user) {
        return this.playerDataMap.get(user);
    }

    @Nullable
    public TotemPlayer getPlayer(Player player) {
        User user = PacketEvents.getAPI().getPlayerManager().getUser((Object)player);
        if (user == null) {
            return null;
        }
        return this.playerDataMap.get(user);
    }

    public void addUser(User user) {
        TotemPlayer player = new TotemPlayer(user);
        this.playerDataMap.put(user, player);
        this.plugin.debug("Added " + user.getName() + " to the player data map.");
    }

    public void remove(User player) {
        this.playerDataMap.remove(player);
        this.plugin.debug("Removed " + player.getName() + " from the player data map.");
    }

    public Collection<TotemPlayer> getEntries() {
        return this.playerDataMap.values();
    }
}

