/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.manager;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.events.PunishEvent;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.database.DatabaseProvider;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PunishmentManager {
    private final TotemGuard plugin;
    private final DatabaseProvider databaseProvider;
    private final Set<UUID> toBePunished = ConcurrentHashMap.newKeySet();

    public PunishmentManager(TotemGuard plugin) {
        this.plugin = plugin;
        this.databaseProvider = plugin.getDatabaseProvider();
    }

    public void punishPlayer(Check check, Component details) {
        if (!check.getCheckSettings().isPunishable()) {
            return;
        }
        if (check.getViolations() < check.getCheckSettings().getMaxViolations()) {
            return;
        }
        if (this.toBePunished.contains(check.getPlayer().getUniqueId())) {
            return;
        }
        if (check.getSettings().isApi()) {
            PunishEvent punishEvent = new PunishEvent(check.getPlayer(), check);
            this.plugin.getServer().getPluginManager().callEvent((Event)punishEvent);
            if (punishEvent.isCancelled()) {
                return;
            }
        }
        this.toBePunished.add(check.getPlayer().getUniqueId());
        this.startPunishment(check, details);
    }

    private void startPunishment(Check check, Component details) {
        int delay = check.getCheckSettings().getPunishmentDelayInSeconds();
        if (delay <= 0) {
            this.executePunishment(check, details);
            this.toBePunished.remove(check.getPlayer().getUniqueId());
        } else {
            FoliaScheduler.getAsyncScheduler().runDelayed((Plugin)this.plugin, o -> {
                this.executePunishment(check, details);
                this.toBePunished.remove(check.getPlayer().getUniqueId());
            }, (long)delay, TimeUnit.SECONDS);
        }
    }

    private void executePunishment(Check check, Component details) {
        this.runPunishmentCommands(check);
        this.plugin.getDiscordManager().sendPunishment(check, PlainTextComponentSerializer.plainText().serialize(details));
        this.databaseProvider.getPunishmentRepository().storePunishment(check);
    }

    private void runPunishmentCommands(Check check) {
        String defaultPunishment = this.plugin.getConfigManager().getChecks().getDefaultPunishment();
        List<String> commands = check.getCheckSettings().getPunishmentCommands();
        ArrayList<String> processedCommands = new ArrayList<String>();
        for (String command : commands) {
            String processedCommand = command.replace("%default_punishment%", defaultPunishment).replace("%player%", check.getPlayer().user.getName()).replace("%uuid%", check.getPlayer().user.getUUID().toString()).replace("%check_name%", check.getCheckName()).replace("%violations%", String.valueOf(check.getViolations())).replace("%max_violations%", String.valueOf(check.getCheckSettings().getMaxViolations())).replace("%server_name%", check.getSettings().getServer());
            processedCommands.add(processedCommand);
        }
        FoliaScheduler.getGlobalRegionScheduler().run((Plugin)this.plugin, o -> {
            for (String command : processedCommands) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), command);
            }
        });
    }
}

