/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.messenger.MessengerService;
import net.kyori.adventure.text.Component;

public class CommandMessengerService {
    private final MessengerService messengerService;
    private final ConfigManager configManager;

    public CommandMessengerService(TotemGuard totemGuard, MessengerService messengerService) {
        this.configManager = totemGuard.getConfigManager();
        this.messengerService = messengerService;
    }

    private Messages.CommandMessages commandMessages() {
        return this.configManager.getMessages().getCommandMessages();
    }

    public Component specifyPlayer() {
        return this.messengerService.format(this.commandMessages().getGenericCommands().getSpecifyPlayer().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component pluginReloaded() {
        return this.messengerService.format(this.commandMessages().getGenericCommands().getPluginReloaded().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component targetNeverJoined() {
        return this.messengerService.format(this.commandMessages().getGenericCommands().getTargetNeverJoined().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component noDatabasePlayerFound(String username) {
        return this.messengerService.format(this.commandMessages().getGenericCommands().getNoDatabasePlayerFound().replace("%prefix%", this.messengerService.getPrefix()).replace("%player%", username));
    }

    public Component targetCannotBeChecked() {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getTargetCannotBeChecked().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component playerNotInSurvival() {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getPlayerNotSurvival().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component playerInvulnerable() {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getPlayerInvulnerable().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component playerNoTotem() {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getPlayerNoTotem().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component targetOnCooldown(long cooldown) {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getTargetOnCooldown().replace("%prefix%", this.messengerService.getPrefix()).replace("%cooldown%", String.valueOf(cooldown)));
    }

    public Component targetNoDamage() {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getTargetNoDamage().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component targetPassedCheck(String target) {
        return this.messengerService.format(this.commandMessages().getCheckCommand().getTargetPassed().replace("%prefix%", this.messengerService.getPrefix()).replace("%player%", target));
    }

    public Component loadingProfile(String target) {
        return this.messengerService.format(this.commandMessages().getProfileCommand().getLoadingProfile().replace("%prefix%", this.messengerService.getPrefix()).replace("%player%", target));
    }
}

