/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.messenger.CommandMessengerService;
import com.deathmotion.totemguard.messenger.impl.AlertMessageService;
import com.deathmotion.totemguard.messenger.impl.ClearLogsMessageService;
import com.deathmotion.totemguard.messenger.impl.DatabaseMessageService;
import com.deathmotion.totemguard.messenger.impl.PlaceHolderService;
import com.deathmotion.totemguard.messenger.impl.ProfileMessageService;
import com.deathmotion.totemguard.messenger.impl.StatsMessageService;
import com.deathmotion.totemguard.util.TGVersions;
import com.deathmotion.totemguard.util.datastructure.Pair;
import lombok.Generated;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class MessengerService {
    private final ConfigManager configManager;
    private final PlaceHolderService placeHolderService;
    private final AlertMessageService alertMessageService;
    private final CommandMessengerService commandMessengerService;
    private final ProfileMessageService profileMessageService;
    private final DatabaseMessageService databaseMessageService;
    private final ClearLogsMessageService clearLogsMessageService;
    private final StatsMessageService statsMessageService;

    public MessengerService(TotemGuard plugin) {
        this.configManager = plugin.getConfigManager();
        this.placeHolderService = new PlaceHolderService(this);
        this.alertMessageService = new AlertMessageService(this);
        this.commandMessengerService = new CommandMessengerService(plugin, this);
        this.profileMessageService = new ProfileMessageService(plugin, this);
        this.databaseMessageService = new DatabaseMessageService(plugin, this);
        this.clearLogsMessageService = new ClearLogsMessageService(plugin, this);
        this.statsMessageService = new StatsMessageService(plugin, this);
    }

    public Component format(String text) {
        return this.configManager.getMessages().getFormat().format(text);
    }

    public String unformat(Component component) {
        return this.configManager.getMessages().getFormat().unformat(component);
    }

    public String getPrefix() {
        return this.configManager.getMessages().getPrefix();
    }

    public String replacePlaceholders(String text, Check check) {
        return this.placeHolderService.replacePlaceHolders(text, check);
    }

    public Component toggleAlerts(boolean enabled) {
        String message = enabled ? this.configManager.getMessages().getAlertsEnabled() : this.configManager.getMessages().getAlertsDisabled();
        message = message.replace("%prefix%", this.getPrefix());
        return this.format(message);
    }

    public Component toggleAlertsOther(boolean enabled, String player) {
        String message = enabled ? this.configManager.getMessages().getAlertsEnabledOther() : this.configManager.getMessages().getAlertsDisabledOther();
        message = message.replace("%prefix%", this.getPrefix()).replace("%player%", player);
        return this.format(message);
    }

    public Component toggleAlertsOtherNoPermission() {
        String message = this.configManager.getMessages().getNoPermissionToggleOther();
        message = message.replace("%prefix%", this.getPrefix());
        return this.format(message);
    }

    public Component toggleAlertsBlockedExternal() {
        String message = this.configManager.getMessages().getAlertToggleBlocked();
        message = message.replace("%prefix%", this.getPrefix());
        return this.format(message);
    }

    public Component totemGuardInfo() {
        BuildableComponent versionComponent = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)" Running ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"TotemGuard", (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)(" v" + String.valueOf(TGVersions.CURRENT)), (TextColor)NamedTextColor.GREEN))).build();
        if (TGVersions.CURRENT.snapshotCommit() != null) {
            versionComponent = versionComponent.append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)" (Git: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)TGVersions.CURRENT.snapshotCommit(), (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.WHITE))).build());
        }
        return this.format(this.getPrefix()).append((Component)versionComponent).append((Component)Component.text((String)" by ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"Bram", (TextColor)NamedTextColor.GREEN)).append((Component)Component.text((String)" and ", (TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)"OutDev", (TextColor)NamedTextColor.GREEN)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"Open Github Page!", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD, TextDecoration.UNDERLINED}))).build())).decorate(TextDecoration.BOLD).clickEvent(ClickEvent.openUrl((String)"https://github.com/Bram1903/TotemGuard"));
    }

    public Pair<Component, Component> createAlert(Check check, Component details) {
        return this.alertMessageService.createAlert(check, details);
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public PlaceHolderService getPlaceHolderService() {
        return this.placeHolderService;
    }

    @Generated
    public AlertMessageService getAlertMessageService() {
        return this.alertMessageService;
    }

    @Generated
    public CommandMessengerService getCommandMessengerService() {
        return this.commandMessengerService;
    }

    @Generated
    public ProfileMessageService getProfileMessageService() {
        return this.profileMessageService;
    }

    @Generated
    public DatabaseMessageService getDatabaseMessageService() {
        return this.databaseMessageService;
    }

    @Generated
    public ClearLogsMessageService getClearLogsMessageService() {
        return this.clearLogsMessageService;
    }

    @Generated
    public StatsMessageService getStatsMessageService() {
        return this.statsMessageService;
    }
}

