/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger.impl;

import com.deathmotion.totemguard.checks.Check;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.util.datastructure.Pair;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;

public class AlertMessageService {
    private final MessengerService messengerService;

    public AlertMessageService(MessengerService messengerService) {
        this.messengerService = messengerService;
    }

    public Pair<Component, Component> createAlert(Check check, Component details) {
        Messages messages = check.getMessages();
        String alertTemplate = messages.getAlertFormat().getAlertFormat();
        String alertConsoleTemplate = messages.getAlertFormat().getAlertFormatConsole();
        String alertHoverTemplate = messages.getAlertFormat().getAlertHoverMessage();
        String alertClickTemplate = messages.getAlertFormat().getAlertClickCommand();
        alertHoverTemplate = this.messengerService.replacePlaceholders(alertHoverTemplate, check);
        if (details.equals((Object)Component.empty())) {
            alertHoverTemplate = alertHoverTemplate.replaceAll("(?m)^%check_details%\\R.*(\\R)?", "");
        }
        Component hoverMessage = this.messengerService.format(alertHoverTemplate.replace("%check_details%", this.messengerService.unformat(details)));
        Component alertMessage = this.messengerService.format(this.messengerService.replacePlaceholders(alertTemplate, check));
        Component consoleMessage = this.messengerService.format(this.messengerService.replacePlaceholders(alertConsoleTemplate, check));
        alertMessage = alertMessage.hoverEvent((HoverEventSource)hoverMessage);
        alertMessage = alertMessage.clickEvent(ClickEvent.runCommand((String)this.messengerService.replacePlaceholders(alertClickTemplate, check)));
        return new Pair<Component, Component>(alertMessage, consoleMessage);
    }
}

