/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.commands.impl.database.util.ValidationType;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.messenger.MessengerService;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;

public class DatabaseMessageService {
    private final MessengerService messengerService;
    private final ConfigManager configManager;

    public DatabaseMessageService(TotemGuard plugin, MessengerService messengerService) {
        this.messengerService = messengerService;
        this.configManager = plugin.getConfigManager();
    }

    private Messages.CommandMessages.DatabaseCommand getDatabaseCommandMessages() {
        return this.configManager.getMessages().getCommandMessages().getDatabaseCommand();
    }

    public Component clearingStartedComponent() {
        return this.messengerService.format(this.getDatabaseCommandMessages().getClearingStarted().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component trimmingStartedComponent() {
        return this.messengerService.format(this.getDatabaseCommandMessages().getTrimmingStarted().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component invalidConfirmationCode() {
        return this.messengerService.format(this.getDatabaseCommandMessages().getInvalidConfirmationCode().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component clearingCompleted(int amount, long duration) {
        return this.messengerService.format(this.getDatabaseCommandMessages().getClearingCompleted().replace("%prefix%", this.messengerService.getPrefix()).replace("%amount%", String.valueOf(amount)).replace("%duration%", String.valueOf(duration)));
    }

    public Component trimmingCompleted(int amount, long duration) {
        return this.messengerService.format(this.getDatabaseCommandMessages().getTrimmingCompleted().replace("%prefix%", this.messengerService.getPrefix()).replace("%amount%", String.valueOf(amount)).replace("%duration%", String.valueOf(duration)));
    }

    public Component confirmationMessage(ValidationType type, int code) {
        Messages.CommandMessages.DatabaseCommand.ActionConfirmationFormat format = this.getDatabaseCommandMessages().getActionConfirmationFormat();
        String messageFormat = format.getActionConfirmationFormat();
        String command = format.getConfirmCommand().replace("%action%", type.toString().toLowerCase()).replace("%code%", String.valueOf(code));
        messageFormat = messageFormat.replace("%action%", type.toString().toLowerCase());
        messageFormat = messageFormat.replace("%command%", command);
        Component message = this.messengerService.format(messageFormat);
        Component confirm = this.messengerService.format(format.getConfirmButton()).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)command)).hoverEvent((HoverEventSource)this.messengerService.format(format.getConfirmHover().replace("%command%", command)));
        message = message.replaceText(builder -> builder.matchLiteral("%confirm_button%").replacement((ComponentLike)confirm));
        return message;
    }
}

