/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.database.entities.BaseDomain;
import com.deathmotion.totemguard.database.entities.DatabaseAlert;
import com.deathmotion.totemguard.database.entities.DatabasePunishment;
import com.deathmotion.totemguard.messenger.MessengerService;
import com.deathmotion.totemguard.models.impl.SafetyStatus;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ProfileMessageService {
    private static final DateTimeFormatter SHORT_DATE_FORMATTER = DateTimeFormatter.ofPattern("MMM dd, yyyy HH:mm");
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private final TotemGuard plugin;
    private final MessengerService messengerService;

    public ProfileMessageService(TotemGuard plugin, MessengerService messengerService) {
        this.plugin = plugin;
        this.messengerService = messengerService;
    }

    public Component createProfileMessage(String username, String clientBrand, int totalAlerts, int totalPunishments, long loadTime, SafetyStatus safetyStatus, List<DatabaseAlert> alerts, List<DatabasePunishment> punishments) {
        Messages messages = this.plugin.getConfigManager().getMessages();
        Messages.CommandMessages.ProfileCommand.ProfileFormat format = messages.getCommandMessages().getProfileCommand().getProfileFormat();
        String profileTemplate = format.getProfileFormat();
        Component alertSummary = this.buildAlertSummary(alerts, format.getAlertSummary(), format.getNoAlertsFound());
        Component punishmentSummary = this.buildPunishmentSummary(punishments, format.getPunishmentSummary(), format.getNoPunishmentsFound(), format.getShowingLastPunishments(), format.getAndMoreToBeDisplayed());
        String filledTemplate = this.replacePlaceholders(profileTemplate, username, clientBrand, totalAlerts, totalPunishments, loadTime, safetyStatus);
        Component profileComponent = this.messengerService.format(filledTemplate);
        profileComponent = profileComponent.replaceText(builder -> builder.match("%alert_summary%").replacement((ComponentLike)alertSummary));
        profileComponent = profileComponent.replaceText(builder -> builder.match("%punishment_summary%").replacement((ComponentLike)punishmentSummary));
        return profileComponent;
    }

    public String replacePlaceholders(String text, String username, String clientBrand, int totalAlerts, int totalPunishments, long loadTime, SafetyStatus safetyStatus) {
        return text.replace("%player%", username).replace("%client_brand%", clientBrand).replace("%safety_status%", this.messengerService.unformat(safetyStatus.toComponent())).replace("%total_alerts%", String.valueOf(totalAlerts)).replace("%total_punishments%", String.valueOf(totalPunishments)).replace("%load_time%", String.valueOf(loadTime));
    }

    private Component buildAlertSummary(List<DatabaseAlert> alerts, String alertSummaryTemplate, String noAlertsTemplate) {
        if (alerts.isEmpty()) {
            return this.messengerService.format(noAlertsTemplate);
        }
        Map<String, Long> groupedAlerts = alerts.stream().collect(Collectors.groupingBy(BaseDomain::getCheckName, Collectors.counting()));
        List sortedEntries = groupedAlerts.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).toList();
        StringBuilder summaryBuilder = new StringBuilder();
        int currentIndex = 0;
        int totalEntries = sortedEntries.size();
        for (Map.Entry entry : sortedEntries) {
            summaryBuilder.append(alertSummaryTemplate.replace("%check_name%", (CharSequence)entry.getKey()).replace("%violations%", String.valueOf(entry.getValue())));
            if (++currentIndex >= totalEntries) continue;
            summaryBuilder.append("\n");
        }
        return this.messengerService.format(summaryBuilder.toString());
    }

    private Component buildPunishmentSummary(List<DatabasePunishment> punishments, String punishmentSummaryTemplate, String noPunishmentsTemplate, String showingLastPunishments, String andMoreToBeDisplayed) {
        if (punishments.isEmpty()) {
            return this.messengerService.format(noPunishmentsTemplate);
        }
        TextComponent summary = Component.empty();
        if (punishments.size() > 3) {
            summary = summary.append(this.messengerService.format(showingLastPunishments)).append((Component)Component.newline());
        }
        List<DatabasePunishment> recentPunishments = punishments.stream().sorted(Comparator.comparing(BaseDomain::getWhenCreated).reversed()).limit(3L).toList();
        List<Component> punishmentComponents = recentPunishments.stream().map(punishment -> {
            ZonedDateTime time = ZonedDateTime.ofInstant(punishment.getWhenCreated(), DEFAULT_ZONE_ID);
            Component message = this.messengerService.format(punishmentSummaryTemplate.replace("%check_name%", punishment.getCheckName()).replace("%date%", time.format(SHORT_DATE_FORMATTER)));
            return message.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("Occurred " + this.getRelativeTime(punishment.getWhenCreated())), (TextColor)NamedTextColor.GRAY)));
        }).toList();
        summary = summary.append(Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.newline()), punishmentComponents));
        if (punishments.size() > 3) {
            summary = summary.append((Component)Component.newline());
            summary = summary.append(this.messengerService.format(andMoreToBeDisplayed));
        }
        return summary;
    }

    public String getRelativeTime(Instant past) {
        Duration duration = Duration.between(past, Instant.now());
        long seconds = duration.getSeconds();
        if (seconds < 60L) {
            return "just now";
        }
        if (seconds < 3600L) {
            return seconds / 60L + " minutes ago";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + " hours ago";
        }
        return seconds / 86400L + " days ago";
    }
}

