/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.messenger.impl;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Messages;
import com.deathmotion.totemguard.manager.ConfigManager;
import com.deathmotion.totemguard.messenger.MessengerService;
import net.kyori.adventure.text.Component;

public class StatsMessageService {
    private final ConfigManager configManager;
    private final MessengerService messengerService;

    public StatsMessageService(TotemGuard plugin, MessengerService messengerService) {
        this.configManager = plugin.getConfigManager();
        this.messengerService = messengerService;
    }

    private Messages.CommandMessages.StatsCommand getStatsCommand() {
        return this.configManager.getMessages().getCommandMessages().getStatsCommand();
    }

    public Component statsLoading() {
        return this.messengerService.format(this.getStatsCommand().getLoadingStats().replace("%prefix%", this.messengerService.getPrefix()));
    }

    public Component stats(int punishmentCount, int alertCount, long punishmentsLast30Days, long punishmentsLast7Days, long punishmentsLastDay, long alertsLast30Days, long alertsLast7Days, long alertsLastDay) {
        Messages.CommandMessages.StatsCommand.StatsFormat statsFormat = this.getStatsCommand().getStatsFormat();
        String punishmentSummary = this.generateSummary(statsFormat.getPunishmentSummary(), punishmentCount, alertCount, punishmentsLast30Days, punishmentsLast7Days, punishmentsLastDay, alertsLast30Days, alertsLast7Days, alertsLastDay, statsFormat.getNoPunishmentsFound(), punishmentsLast30Days);
        String alertSummary = this.generateSummary(statsFormat.getAlertSummary(), punishmentCount, alertCount, punishmentsLast30Days, punishmentsLast7Days, punishmentsLastDay, alertsLast30Days, alertsLast7Days, alertsLastDay, statsFormat.getNoAlertsFound(), alertsLast30Days);
        String message = this.replacePlaceholders(statsFormat.getStatsFormat(), punishmentCount, alertCount, punishmentsLast30Days, punishmentsLast7Days, punishmentsLastDay, alertsLast30Days, alertsLast7Days, alertsLastDay).replace("%punishment_summary%", punishmentSummary).replace("%alert_summary%", alertSummary);
        return this.messengerService.format(message);
    }

    private String generateSummary(String template, int punishmentCount, int alertCount, long punishmentsLast30Days, long punishmentsLast7Days, long punishmentsLastDay, long alertsLast30Days, long alertsLast7Days, long alertsLastDay, String noDataMessage, long relevantCount) {
        if (relevantCount == 0L) {
            return noDataMessage;
        }
        return this.replacePlaceholders(template, punishmentCount, alertCount, punishmentsLast30Days, punishmentsLast7Days, punishmentsLastDay, alertsLast30Days, alertsLast7Days, alertsLastDay);
    }

    private String replacePlaceholders(String template, int punishmentCount, int alertCount, long punishmentsLast30Days, long punishmentsLast7Days, long punishmentsLastDay, long alertsLast30Days, long alertsLast7Days, long alertsLastDay) {
        return template.replace("%total_punishments%", String.valueOf(punishmentCount)).replace("%total_alerts%", String.valueOf(alertCount)).replace("%punishment_last_30%", String.valueOf(punishmentsLast30Days)).replace("%punishment_last_7%", String.valueOf(punishmentsLast7Days)).replace("%punishment_last_24h%", String.valueOf(punishmentsLastDay)).replace("%alerts_last_30%", String.valueOf(alertsLast30Days)).replace("%alerts_last_7%", String.valueOf(alertsLast7Days)).replace("%alerts_last_24h%", String.valueOf(alertsLastDay));
    }
}

