/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.models;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.interfaces.AbstractCheck;
import com.deathmotion.totemguard.api.interfaces.TotemUser;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsB;
import com.deathmotion.totemguard.checks.impl.badpackets.BadPacketsD;
import com.deathmotion.totemguard.checks.impl.misc.ClientBrand;
import com.deathmotion.totemguard.database.entities.DatabasePlayer;
import com.deathmotion.totemguard.manager.CheckManager;
import com.deathmotion.totemguard.models.impl.DigAndPickupState;
import com.deathmotion.totemguard.models.impl.PingData;
import com.deathmotion.totemguard.models.impl.TotemData;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.protocol.player.User;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TotemPlayer
implements TotemUser {
    public final CheckManager checkManager;
    public final TotemData totemData;
    public final PingData pingData;
    public final UUID uniqueId;
    public final User user;
    public Player bukkitPlayer;
    public boolean firstChunkReceived;
    public boolean delayedChecksRan;
    public boolean isUsingLunarClient;
    public DigAndPickupState digAndPickupState;
    @Nullable
    public DatabasePlayer databasePlayer;
    public boolean sendingBundlePacket;

    public TotemPlayer(User user) {
        this.uniqueId = user.getUUID();
        this.user = user;
        this.checkManager = new CheckManager(this);
        this.totemData = new TotemData();
        this.pingData = new PingData();
        this.digAndPickupState = new DigAndPickupState();
    }

    public void reload() {
        for (AbstractCheck value : this.checkManager.allChecks.values()) {
            value.reload();
        }
    }

    public void handlePlayerLogin(Player player) {
        this.bukkitPlayer = player;
        if (!TotemGuard.getInstance().getPlayerDataManager().shouldCheck(this.user, this.bukkitPlayer)) {
            TotemGuard.getInstance().getPlayerDataManager().remove(this.user);
            return;
        }
        FoliaScheduler.getAsyncScheduler().runNow((Plugin)TotemGuard.getInstance(), o -> {
            this.databasePlayer = TotemGuard.getInstance().getDatabaseProvider().getPlayerRepository().retrieveOrRefreshPlayer(this);
        });
    }

    private void scheduleCheck(Runnable task) {
        long ping = Math.max(0L, (long)this.getPing());
        long delay = (ping + 5L) * 5L;
        FoliaScheduler.getAsyncScheduler().runDelayed((Plugin)TotemGuard.getInstance(), ignored -> task.run(), delay, TimeUnit.MILLISECONDS);
    }

    public void runFirstChunkLoadedChecks() {
        if (this.firstChunkReceived) {
            return;
        }
        this.firstChunkReceived = true;
        this.scheduleCheck(() -> {
            this.checkManager.getGenericCheck(BadPacketsB.class).handle();
            this.checkManager.triggerSignChecks();
        });
    }

    public void runDelayedChecks() {
        if (!this.firstChunkReceived || this.delayedChecksRan) {
            return;
        }
        this.delayedChecksRan = true;
        this.scheduleCheck(() -> this.checkManager.getGenericCheck(BadPacketsD.class).handle());
    }

    @Override
    public String getBrand() {
        return this.checkManager.getPacketCheck(ClientBrand.class).getBrand();
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getVersionName() {
        return this.user.getClientVersion().getReleaseName();
    }

    @Override
    public int getKeepAlivePing() {
        if (this.bukkitPlayer == null) {
            return -1;
        }
        return PacketEvents.getAPI().getPlayerManager().getPing((Object)this.bukkitPlayer);
    }

    public int getPing() {
        int transactionPing = this.pingData.getTransactionPing();
        if (transactionPing == -1) {
            return this.getKeepAlivePing();
        }
        return transactionPing;
    }
}

