/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.models.impl;

import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public enum SafetyStatus {
    SAFE("Safe", NamedTextColor.GREEN),
    ALERTED("Alerted", NamedTextColor.YELLOW),
    SUSPICIOUS("Suspicious", NamedTextColor.GOLD),
    DANGEROUS("Dangerous", NamedTextColor.RED),
    DIABOLICAL("Diabolical", NamedTextColor.DARK_RED);

    private final String status;
    private final NamedTextColor color;

    private SafetyStatus(String status, NamedTextColor color) {
        this.status = status;
        this.color = color;
    }

    public static SafetyStatus getSafetyStatus(int alerts, int punishments) {
        if (alerts == 0 && punishments == 0) {
            return SAFE;
        }
        if (punishments > 2) {
            if (alerts > 7) {
                return DIABOLICAL;
            }
            if (alerts > 4) {
                return DANGEROUS;
            }
            return SUSPICIOUS;
        }
        if (punishments > 0) {
            if (alerts > 8) {
                return DIABOLICAL;
            }
            if (alerts > 5) {
                return DANGEROUS;
            }
            if (alerts > 2) {
                return SUSPICIOUS;
            }
            return ALERTED;
        }
        if (alerts > 7) {
            return DANGEROUS;
        }
        if (alerts > 4) {
            return SUSPICIOUS;
        }
        return ALERTED;
    }

    public Component toComponent() {
        return Component.text((String)this.status, (TextColor)this.color);
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public NamedTextColor getColor() {
        return this.color;
    }
}

