/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.models.impl;

import com.deathmotion.totemguard.util.MathUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.stream.Collectors;
import lombok.Generated;

public class TotemData {
    private final ConcurrentLinkedDeque<Long> intervals = new ConcurrentLinkedDeque();
    private boolean expectingTotemSwap;
    private Long lastTotemUsage;
    private double latestStandardDeviation;

    public void addInterval(long interval) {
        this.intervals.addLast(interval);
        if (this.intervals.size() >= 50) {
            this.intervals.poll();
        }
        this.latestStandardDeviation = MathUtil.trim(2, MathUtil.getStandardDeviation(this.intervals));
    }

    public List<Long> getLatestIntervals(int amount) {
        return this.intervals.stream().skip(Math.max(0, this.intervals.size() - amount)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> {
            Collections.reverse(list);
            return list;
        }));
    }

    @Generated
    public boolean isExpectingTotemSwap() {
        return this.expectingTotemSwap;
    }

    @Generated
    public Long getLastTotemUsage() {
        return this.lastTotemUsage;
    }

    @Generated
    public double getLatestStandardDeviation() {
        return this.latestStandardDeviation;
    }

    @Generated
    public ConcurrentLinkedDeque<Long> getIntervals() {
        return this.intervals;
    }

    @Generated
    public void setExpectingTotemSwap(boolean expectingTotemSwap) {
        this.expectingTotemSwap = expectingTotemSwap;
    }

    @Generated
    public void setLastTotemUsage(Long lastTotemUsage) {
        this.lastTotemUsage = lastTotemUsage;
    }

    @Generated
    public void setLatestStandardDeviation(double latestStandardDeviation) {
        this.latestStandardDeviation = latestStandardDeviation;
    }
}

