/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.redis;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.config.Settings;
import com.deathmotion.totemguard.interfaces.Reloadable;
import com.deathmotion.totemguard.redis.handlers.SyncAlertMessageHandler;
import com.deathmotion.totemguard.redis.packet.Packet;
import com.deathmotion.totemguard.redis.packet.PacketRegistry;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class RedisService
extends RedisPubSubAdapter<byte[], byte[]>
implements Reloadable {
    private final TotemGuard plugin;
    private final PacketRegistry registry;
    private final List<Reloadable> handlers = new ArrayList<Reloadable>();
    private final String identifier;
    @Nullable
    private RedisClient client = null;
    @Nullable
    private StatefulRedisPubSubConnection<byte[], byte[]> pubsub = null;
    @Nullable
    private StatefulRedisConnection<byte[], byte[]> publishConnection = null;
    private byte @Nullable [] channel;

    public RedisService(TotemGuard plugin) {
        this.plugin = plugin;
        this.registry = new PacketRegistry();
        this.identifier = UUID.randomUUID().toString();
        this.start();
        this.handlers.add(new SyncAlertMessageHandler(plugin, this.registry));
    }

    private void start() {
        Settings.Redis redisSettings = this.plugin.getConfigManager().getSettings().getRedis();
        if (!redisSettings.isEnabled()) {
            return;
        }
        this.client = this.createRedisClient(redisSettings);
        this.channel = redisSettings.getChannel().getBytes(StandardCharsets.UTF_8);
        this.pubsub = this.client.connectPubSub((RedisCodec)new ByteArrayCodec());
        this.pubsub.async().subscribe((Object[])new byte[][]{this.channel});
        this.pubsub.addListener((RedisPubSubListener)this);
        this.publishConnection = this.client.connect((RedisCodec)new ByteArrayCodec());
    }

    public void stop() {
        if (this.pubsub != null) {
            this.pubsub.close();
        }
        if (this.publishConnection != null) {
            this.publishConnection.close();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    @Override
    public void reload() {
        this.stop();
        this.start();
        this.handlers.forEach(Reloadable::reload);
    }

    public void message(byte[] channelBytes, byte[] messageBytes) {
        if (this.isInvalidMessage(channelBytes, messageBytes)) {
            return;
        }
        if (!Arrays.equals(channelBytes, this.channel)) {
            return;
        }
        ByteArrayDataInput dataInput = ByteStreams.newDataInput((byte[])messageBytes);
        String senderIdentifier = dataInput.readUTF();
        if (senderIdentifier.equals(this.identifier)) {
            return;
        }
        this.registry.handlePacket(dataInput);
    }

    public <T> void publish(Packet<T> packet, T obj) {
        ByteArrayDataOutput dataOutput = packet.write(obj);
        byte[] payload = dataOutput.toByteArray();
        ByteArrayDataOutput finalOutput = ByteStreams.newDataOutput();
        finalOutput.writeUTF(this.identifier);
        finalOutput.write(payload);
        this.publish(finalOutput.toByteArray());
    }

    public void publish(byte[] data) {
        if (this.publishConnection == null) {
            this.plugin.debug("Attempted to publish data to Redis, but the connection is not established.");
            return;
        }
        this.publishConnection.async().publish((Object)this.channel, (Object)data);
    }

    private boolean isInvalidMessage(byte[] channelBytes, byte[] messageBytes) {
        return channelBytes == null || messageBytes == null || channelBytes.length == 0 || messageBytes.length == 0;
    }

    private RedisClient createRedisClient(Settings.Redis redisSettings) {
        RedisURI.Builder uriBuilder = RedisURI.builder().withHost(redisSettings.getHost()).withPort(redisSettings.getPort());
        if (redisSettings.getUsername() != null && !redisSettings.getUsername().isEmpty() && redisSettings.getPassword() != null && !redisSettings.getPassword().isEmpty()) {
            uriBuilder.withAuthentication(redisSettings.getUsername(), (CharSequence)redisSettings.getPassword());
        }
        return RedisClient.create((RedisURI)uriBuilder.build());
    }

    @Generated
    public TotemGuard getPlugin() {
        return this.plugin;
    }

    @Generated
    public PacketRegistry getRegistry() {
        return this.registry;
    }

    @Generated
    public List<Reloadable> getHandlers() {
        return this.handlers;
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Nullable
    @Generated
    public RedisClient getClient() {
        return this.client;
    }

    @Nullable
    @Generated
    public StatefulRedisPubSubConnection<byte[], byte[]> getPubsub() {
        return this.pubsub;
    }

    @Nullable
    @Generated
    public StatefulRedisConnection<byte[], byte[]> getPublishConnection() {
        return this.publishConnection;
    }

    @Generated
    public byte @Nullable [] getChannel() {
        return this.channel;
    }
}

