/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.redis.handlers;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.interfaces.Reloadable;
import com.deathmotion.totemguard.redis.packet.PacketProcessor;
import com.deathmotion.totemguard.redis.packet.PacketRegistry;
import com.deathmotion.totemguard.redis.packet.Packets;
import com.deathmotion.totemguard.redis.packet.impl.SyncAlertMessagePacket;

public class SyncAlertMessageHandler
implements PacketProcessor<SyncAlertMessagePacket.AlertComponents>,
Reloadable {
    private final TotemGuard plugin;
    private final PacketRegistry registry;

    public SyncAlertMessageHandler(TotemGuard plugin, PacketRegistry registry) {
        this.plugin = plugin;
        this.registry = registry;
        registry.registerProcessor(Packets.SYNC_ALERT_MESSAGE.getId(), this);
    }

    @Override
    public void handle(SyncAlertMessagePacket.AlertComponents alertComponents) {
        this.plugin.getAlertManager().sendAlert(alertComponents);
    }

    @Override
    public void reload() {
        this.registry.unregister(Packets.SYNC_ALERT_MESSAGE.getId(), this);
        if (!this.plugin.getConfigManager().getSettings().getRedis().isSyncAlerts()) {
            return;
        }
        this.registry.registerProcessor(Packets.SYNC_ALERT_MESSAGE.getId(), this);
    }
}

