/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.redis.packet;

import com.deathmotion.totemguard.api.versioning.TGVersion;
import com.deathmotion.totemguard.util.TGVersions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import lombok.Generated;

public abstract class Packet<T> {
    private final int packetId;

    public Packet(int packetId) {
        this.packetId = packetId;
    }

    public ByteArrayDataOutput write(T obj) {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        this.writeVersion(output);
        output.writeInt(this.packetId);
        this.writeData(output, obj);
        return output;
    }

    public abstract T read(ByteArrayDataInput var1);

    public abstract void writeData(ByteArrayDataOutput var1, T var2);

    private void writeVersion(ByteArrayDataOutput output) {
        TGVersion version = TGVersions.CURRENT;
        output.writeByte(version.major());
        output.writeByte(version.minor());
        int patchAndSnapshot = (version.snapshot() ? 128 : 0) | version.patch() & 0x7F;
        output.writeByte(patchAndSnapshot);
    }

    @Generated
    public int getPacketId() {
        return this.packetId;
    }
}

