/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.redis.packet;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.versioning.TGVersion;
import com.deathmotion.totemguard.redis.packet.Packet;
import com.deathmotion.totemguard.redis.packet.PacketProcessor;
import com.deathmotion.totemguard.redis.packet.Packets;
import com.deathmotion.totemguard.util.TGVersions;
import com.google.common.io.ByteArrayDataInput;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PacketRegistry {
    private final ConcurrentMap<Integer, Packet<?>> packets = new ConcurrentHashMap();
    private final ConcurrentMap<Integer, List<PacketProcessor<?>>> processors = new ConcurrentHashMap();

    public PacketRegistry() {
        for (Packets packet : Packets.values()) {
            this.packets.put(packet.getId(), packet.getPacket());
        }
    }

    public <T> void registerProcessor(int packetId, PacketProcessor<T> processor) {
        Packet packet = (Packet)this.packets.get(packetId);
        if (packet == null) {
            throw new IllegalArgumentException("Invalid packet ID: " + packetId);
        }
        this.processors.computeIfAbsent(packetId, k -> new CopyOnWriteArrayList()).add(processor);
    }

    public void unregister(int packetId, PacketProcessor<?> processor) {
        Optional.ofNullable((List)this.processors.get(packetId)).ifPresent(list -> list.remove(processor));
    }

    public void handlePacket(ByteArrayDataInput dataInput) {
        TGVersion version = this.readVersion(dataInput);
        if (!TGVersions.CURRENT.equalsWithoutCommit(version)) {
            TotemGuard.getInstance().getLogger().warning("TotemGuard packet version mismatch: received version " + String.valueOf(version) + " (expected " + String.valueOf(TGVersions.CURRENT) + "). Ensure all servers are running the latest version of TotemGuard.");
            return;
        }
        int packetId = dataInput.readInt();
        Packet packet = (Packet)this.packets.get(packetId);
        if (packet == null) {
            throw new IllegalArgumentException("Invalid packet ID: " + packetId);
        }
        List processorsForPacket = (List)this.processors.get(packetId);
        if (processorsForPacket == null || processorsForPacket.isEmpty()) {
            return;
        }
        Object packetData = packet.read(dataInput);
        processorsForPacket.forEach(processor -> processor.handleAny(packetData));
    }

    private TGVersion readVersion(ByteArrayDataInput input) {
        int major = input.readUnsignedByte();
        int minor = input.readUnsignedByte();
        int patchAndSnapshot = input.readUnsignedByte();
        boolean snapshot = (patchAndSnapshot & 0x80) != 0;
        int patch = patchAndSnapshot & 0x7F;
        return new TGVersion(major, minor, patch, snapshot);
    }
}

