/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.redis.packet.impl;

import com.deathmotion.totemguard.redis.packet.Packet;
import com.deathmotion.totemguard.redis.packet.Packets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public class SyncAlertMessagePacket
extends Packet<AlertComponents> {
    public SyncAlertMessagePacket() {
        super(Packets.SYNC_ALERT_MESSAGE.getId());
    }

    @Override
    public AlertComponents read(ByteArrayDataInput input) {
        String gameAlert = input.readUTF();
        String consoleAlert = input.readUTF();
        return new AlertComponents(GsonComponentSerializer.gson().deserialize((Object)gameAlert), GsonComponentSerializer.gson().deserialize((Object)consoleAlert));
    }

    @Override
    public void writeData(ByteArrayDataOutput output, AlertComponents alertComponents) {
        String gameAlert = (String)GsonComponentSerializer.gson().serialize(alertComponents.gameAlert);
        String consoleAlert = (String)GsonComponentSerializer.gson().serialize(alertComponents.consoleAlert);
        output.writeUTF(gameAlert);
        output.writeUTF(consoleAlert);
    }

    public static class AlertComponents {
        public Component gameAlert;
        public Component consoleAlert;

        @Generated
        public AlertComponents(Component gameAlert, Component consoleAlert) {
            this.gameAlert = gameAlert;
            this.consoleAlert = consoleAlert;
        }
    }
}

