/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.util;

import java.util.function.Function;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;

public enum Formatter {
    MINIMESSAGE(text -> MiniMessage.miniMessage().deserialize(text), "MiniMessage"),
    LEGACY(text -> Formatter.getLegacySerializer().deserialize(Formatter.replaceHexColorCodes(text)), "Legacy Text");

    private static final LegacyComponentSerializer LEGACY_SERIALIZER;
    private final String name;
    private final Function<String, Component> formatter;

    private Formatter(Function<String, Component> formatter, String name) {
        this.formatter = formatter;
        this.name = name;
    }

    @NotNull
    private static String replaceHexColorCodes(@NotNull String text) {
        return text.replace('\u00a7', '&');
    }

    private static LegacyComponentSerializer getLegacySerializer() {
        return LEGACY_SERIALIZER;
    }

    public Component format(@NotNull String text) {
        return this.formatter.apply(text);
    }

    public String unformat(@NotNull Component component) {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> (String)MiniMessage.miniMessage().serialize(component);
            case 1 -> Formatter.getLegacySerializer().serialize(component);
        };
    }

    @Generated
    private static LegacyComponentSerializer getLEGACY_SERIALIZER() {
        return LEGACY_SERIALIZER;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        LEGACY_SERIALIZER = LegacyComponentSerializer.builder().character('&').hexCharacter('#').useUnusualXRepeatedCharacterHexFormat().hexColors().build();
    }
}

