/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.util;

import com.deathmotion.totemguard.util.datastructure.Pair;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public final class MathUtil {
    public static final double expander = Math.pow(2.0, 24.0);

    public static double sum(Function<Number, Double> function, Collection<? extends Number> dataSet) {
        return dataSet.stream().map(function).mapToDouble(i -> i).sum();
    }

    public static int floor(double d) {
        return (int)Math.floor(d);
    }

    public static Pair<List<Double>, List<Double>> getOutliers(Collection<? extends Number> collection) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Number number : collection) {
            values.add(number.doubleValue());
        }
        double q1 = MathUtil.getMedian(values.subList(0, values.size() / 2));
        double q3 = MathUtil.getMedian(values.subList(values.size() / 2, values.size()));
        double iqr = Math.abs(q1 - q3);
        double lowThreshold = q1 - 1.5 * iqr;
        double highThreshold = q3 + 1.5 * iqr;
        Pair<List<Double>, List<Double>> tuple = new Pair<List<Double>, List<Double>>(new ArrayList(), new ArrayList());
        for (Double value : values) {
            if (value < lowThreshold) {
                tuple.getX().add(value);
                continue;
            }
            if (!(value > highThreshold)) continue;
            tuple.getY().add(value);
        }
        return tuple;
    }

    public static double getVariance(Collection<? extends Number> data) {
        double mean = MathUtil.getMean(data);
        return MathUtil.sum(i -> Math.pow(i.doubleValue() - mean, 2.0), data) / (double)(data.size() - 1);
    }

    public static double getStandardDeviation(Collection<? extends Number> data) {
        double variance = MathUtil.getVariance(data);
        return MathUtil.fastSqrt(variance);
    }

    public static double getMedian(List<Double> data) {
        if (data.size() % 2 == 0) {
            return (data.get(data.size() / 2) + data.get(data.size() / 2 - 1)) / 2.0;
        }
        return data.get(data.size() / 2);
    }

    public static double getMean(Collection<? extends Number> iterable) {
        return MathUtil.sum(Number::doubleValue, iterable) / (double)iterable.size();
    }

    public static double getKurtosis(Collection<? extends Number> data) {
        double n = data.size();
        double mean = MathUtil.getMean(data);
        double variance = MathUtil.getVariance(data);
        double a = n * (n + 1.0) / ((n - 1.0) * (n - 2.0) * (n - 3.0));
        double b = MathUtil.sum(i -> Math.pow(i.doubleValue() - mean, 2.0), data) / Math.pow(variance, 2.0);
        return a * b;
    }

    public static double getExcessKurtosis(Collection<? extends Number> data) {
        double n = data.size();
        double a = 3.0 * Math.pow(n - 1.0, 2.0) / ((n - 2.0) * (n - 3.0));
        return MathUtil.getKurtosis(data) - a;
    }

    public static double getSkewness(Collection<? extends Number> data) {
        double mean = MathUtil.getMean(data);
        double deviation = MathUtil.getStandardDeviation(data);
        return MathUtil.sum(i -> Math.pow(i.doubleValue() - mean, 3.0), data) / ((double)(data.size() - 1) * Math.pow(deviation, 3.0));
    }

    public static Number getMode(Collection<? extends Number> array) {
        Number mode = (Number)array.toArray()[0];
        int maxCount = 0;
        for (Number number : array) {
            int count = 1;
            for (Number number2 : array) {
                if (number2.equals(number)) {
                    ++count;
                }
                if (count <= maxCount) continue;
                mode = number;
                maxCount = count;
            }
        }
        return mode;
    }

    public static double trim(int degree, double d) {
        StringBuilder format = new StringBuilder("#.#");
        for (int i = 1; i < degree; ++i) {
            format.append("#");
        }
        DecimalFormat twoDForm = new DecimalFormat(format.toString());
        return Double.parseDouble(twoDForm.format(d).replaceAll(",", "."));
    }

    public static long gcd(long limit, long a, long b) {
        return b <= limit ? a : MathUtil.gcd(limit, b, a % b);
    }

    public static boolean isBetween(double number, double d1, double d2) {
        return number > d1 && number < d2;
    }

    public static boolean areRoughlyEqual(double amount, double one, double two) {
        return Math.abs(one - two) <= amount;
    }

    public static double getPercentage(double one, double two) {
        return one / two * 100.0;
    }

    public static double differenceBetween(double g, double q) {
        return g > q ? g - q : q - g;
    }

    public static double fastSqrt(double n) {
        return Double.longBitsToDouble((Double.doubleToLongBits(n) - 0x10000000000000L >> 1) + 0x2000000000000000L);
    }

    public static double getClosest(double a, double b, double closeTest) {
        return Math.abs(closeTest - a) < Math.abs(closeTest - b) ? a : b;
    }

    public static Vector getRotation(Location one, Location two) {
        double dx = two.getX() - one.getX();
        double dy = two.getY() - one.getY();
        double dz = two.getZ() - one.getZ();
        double distanceXZ = Math.sqrt(dx * dx + dz * dz);
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(dy, distanceXZ) * 180.0 / Math.PI));
        return new Vector(yaw, pitch, 0.0f);
    }

    public static double clamp180(double theta) {
        if ((theta %= 360.0) >= 180.0) {
            theta -= 360.0;
        }
        if (theta < -180.0) {
            theta += 360.0;
        }
        return theta;
    }

    public static boolean isScientificNotation(double d) {
        return String.valueOf(d).contains("E");
    }

    public static Vector getDirection(float yaw, float pitch) {
        Vector vector = new Vector();
        float rotX = (float)Math.toRadians(yaw);
        float rotY = (float)Math.toRadians(pitch);
        vector.setY(-Math.sin(rotY));
        double xz = Math.cos(rotY);
        vector.setX(-xz * Math.sin(rotX));
        vector.setZ(xz * Math.cos(rotX));
        return vector;
    }

    public static double angle(Vector a, Vector b) {
        double dot = Math.min(Math.max(a.dot(b) / (a.length() * b.length()), -1.0), 1.0);
        return Math.acos(dot);
    }

    @Generated
    private MathUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

