/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.util;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.models.TotemPlayer;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import com.github.retrooper.packetevents.protocol.nbt.NBT;
import com.github.retrooper.packetevents.protocol.nbt.NBTByte;
import com.github.retrooper.packetevents.protocol.nbt.NBTCompound;
import com.github.retrooper.packetevents.protocol.nbt.NBTList;
import com.github.retrooper.packetevents.protocol.nbt.NBTString;
import com.github.retrooper.packetevents.protocol.nbt.NBTType;
import com.github.retrooper.packetevents.protocol.world.blockentity.BlockEntityTypes;
import com.github.retrooper.packetevents.protocol.world.states.WrappedBlockState;
import com.github.retrooper.packetevents.protocol.world.states.type.StateType;
import com.github.retrooper.packetevents.protocol.world.states.type.StateTypes;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBlockEntityData;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerBundle;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerCloseWindow;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerOpenSignEditor;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class SignUtil {
    private static final int MAX_KEYS = 3;
    private static final String NBT_FRONT_TEXT = "front_text";
    private static final String NBT_BACK_TEXT = "back_text";
    private static final String NBT_MESSAGES = "messages";
    private static final String NBT_GLOWING = "has_glowing_text";
    private static final String NBT_IS_WAXED = "is_waxed";
    private static final String COMP_TEXT = "text";
    private static final String COMP_KEYBIND = "keybind";
    private static final ServerVersion SERVER_VERSION = PacketEvents.getAPI().getServerManager().getVersion();
    private static final Logger LOG = TotemGuard.getInstance().getLogger();

    public static void placeSign(TotemPlayer totemPlayer, UUID packetSecret, List<String> keys) {
        Location loc = totemPlayer.bukkitPlayer.getLocation();
        boolean wasBundling = totemPlayer.sendingBundlePacket;
        NBTCompound signNbt = SignUtil.buildSignNbt(packetSecret, keys);
        FoliaScheduler.getRegionScheduler().run((Plugin)TotemGuard.getInstance(), loc, task -> {
            WrappedBlockState original = SpigotConversionUtil.fromBukkitBlockData((BlockData)loc.getBlock().getState().getBlockData());
            FoliaScheduler.getAsyncScheduler().runNow((Plugin)TotemGuard.getInstance(), task2 -> {
                Vector3i pos = SpigotConversionUtil.fromBukkitLocation((Location)loc).getPosition().toVector3i();
                WrapperPlayServerBundle bundle = new WrapperPlayServerBundle();
                WrapperPlayServerBlockChange placeSign = new WrapperPlayServerBlockChange(pos, WrappedBlockState.getDefaultState((StateType)StateTypes.OAK_SIGN));
                WrapperPlayServerBlockEntityData setText = new WrapperPlayServerBlockEntityData(pos, BlockEntityTypes.SIGN, signNbt);
                WrapperPlayServerOpenSignEditor openEditor = new WrapperPlayServerOpenSignEditor(pos, true);
                WrapperPlayServerCloseWindow closeEditor = new WrapperPlayServerCloseWindow();
                WrapperPlayServerBlockChange revertBlock = new WrapperPlayServerBlockChange(pos, original);
                if (!wasBundling) {
                    totemPlayer.user.sendPacket((PacketWrapper)bundle);
                }
                totemPlayer.user.sendPacket((PacketWrapper)placeSign);
                totemPlayer.user.sendPacket((PacketWrapper)setText);
                totemPlayer.user.sendPacket((PacketWrapper)openEditor);
                totemPlayer.user.sendPacket((PacketWrapper)closeEditor);
                totemPlayer.user.sendPacket((PacketWrapper)revertBlock);
                if (!wasBundling) {
                    totemPlayer.user.sendPacket((PacketWrapper)bundle);
                }
            });
        });
    }

    public static boolean isSignContentValid(UUID packetSecret, String[] textLines, List<String> originalKeys) {
        if (!SignUtil.isOurSign(packetSecret, textLines)) {
            return false;
        }
        List<String> keys = SignUtil.safeKeys(originalKeys);
        for (int i = 1; i < (textLines == null ? 0 : textLines.length); ++i) {
            String line = textLines[i];
            if (line == null || line.isEmpty() || keys.contains(line)) continue;
            return true;
        }
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static NBTCompound buildSignNbt(UUID packetSecret, List<String> keys) {
        if (SERVER_VERSION.isOlderThan(ServerVersion.V_1_20)) {
            List<String> jsonLines = SignUtil.buildFourJsonStrings(packetSecret, keys);
            NBTCompound legacy = new NBTCompound();
            for (int i = 0; i < 4; ++i) {
                legacy.setTag("Text" + (i + 1), (NBT)new NBTString(jsonLines.get(i)));
            }
            return legacy;
        }
        if (SERVER_VERSION.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            List<NBTCompound> comps = SignUtil.buildFourCompounds(packetSecret, keys);
            @NotNull NBTList messages = new NBTList(NBTType.COMPOUND);
            for (NBTCompound c : comps) {
                messages.addTag((NBT)c);
            }
            return SignUtil.signRoot(messages);
        }
        List<String> jsonLines = SignUtil.buildFourJsonStrings(packetSecret, keys);
        @NotNull NBTList messages = new NBTList(NBTType.STRING);
        for (String json : jsonLines) {
            messages.addTag((NBT)new NBTString(json));
        }
        return SignUtil.signRoot(messages);
    }

    @NotNull
    private static NBTCompound signRoot(NBTList<?> messages) {
        NBTCompound text = SignUtil.compoundWithMessages(messages);
        NBTCompound root = new NBTCompound();
        root.setTag(NBT_FRONT_TEXT, (NBT)text);
        root.setTag(NBT_BACK_TEXT, (NBT)text);
        root.setTag(NBT_IS_WAXED, (NBT)new NBTByte(0));
        return root;
    }

    @NotNull
    private static NBTCompound compoundWithMessages(NBTList<?> messages) {
        NBTCompound c = new NBTCompound();
        c.setTag(NBT_MESSAGES, messages);
        c.setTag(NBT_GLOWING, (NBT)new NBTByte(0));
        return c;
    }

    @NotNull
    private static List<String> buildFourJsonStrings(UUID secret, List<String> keys) {
        return SignUtil.fourLines(secret, keys, SignUtil::jsonText, SignUtil::jsonKeybind, SignUtil::jsonEmpty);
    }

    @NotNull
    private static List<NBTCompound> buildFourCompounds(UUID secret, List<String> keys) {
        ArrayList<NBTCompound> out = new ArrayList<NBTCompound>(4);
        List<String> safe = SignUtil.safeKeys(keys);
        SignUtil.warnOnKeyCount(safe);
        out.add(SignUtil.compText(secret == null ? "" : secret.toString()));
        out.add(safe.size() >= 1 && SignUtil.nonEmpty(safe.get(0)) ? SignUtil.compKeybind(safe.get(0)) : SignUtil.compText(""));
        out.add(safe.size() >= 2 && SignUtil.nonEmpty(safe.get(1)) ? SignUtil.compKeybind(safe.get(1)) : SignUtil.compText(""));
        out.add(safe.size() >= 3 && SignUtil.nonEmpty(safe.get(2)) ? SignUtil.compKeybind(safe.get(2)) : SignUtil.compText(""));
        return out;
    }

    @NotNull
    private static List<String> fourLines(UUID secret, List<String> keys, LineRenderer textRenderer, LineRenderer keyRenderer, SupplierRenderer emptyRenderer) {
        List<String> safe = SignUtil.safeKeys(keys);
        SignUtil.warnOnKeyCount(safe);
        ArrayList<String> out = new ArrayList<String>(4);
        out.add(textRenderer.render(secret == null ? "" : secret.toString()));
        out.add(safe.size() >= 1 && SignUtil.nonEmpty(safe.get(0)) ? keyRenderer.render(safe.get(0)) : emptyRenderer.render());
        out.add(safe.size() >= 2 && SignUtil.nonEmpty(safe.get(1)) ? keyRenderer.render(safe.get(1)) : emptyRenderer.render());
        out.add(safe.size() >= 3 && SignUtil.nonEmpty(safe.get(2)) ? keyRenderer.render(safe.get(2)) : emptyRenderer.render());
        return out;
    }

    private static void warnOnKeyCount(List<String> keys) {
        if (keys.isEmpty()) {
            LOG.warning("Tried to send a sign without any content!");
        }
        if (keys.size() > 3) {
            LOG.warning("Tried to send a sign with more than 3 lines of content!");
        }
    }

    @NotNull
    private static List<String> safeKeys(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        return keys;
    }

    private static boolean nonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    @NotNull
    private static String jsonText(String text) {
        return "{\"text\":" + SignUtil.quote(text) + "}";
    }

    @NotNull
    private static String jsonKeybind(String keybind) {
        return "{\"keybind\":" + SignUtil.quote(keybind == null ? "" : keybind) + "}";
    }

    @NotNull
    private static String jsonEmpty() {
        return "{\"text\":\"\"}";
    }

    @NotNull
    private static String quote(String s) {
        if (s == null) {
            s = "";
        }
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
    }

    @NotNull
    private static NBTCompound compText(String text) {
        NBTCompound c = new NBTCompound();
        c.setTag(COMP_TEXT, (NBT)new NBTString(text == null ? "" : text));
        return c;
    }

    @NotNull
    private static NBTCompound compKeybind(String key) {
        NBTCompound c = new NBTCompound();
        c.setTag(COMP_KEYBIND, (NBT)new NBTString(key == null ? "" : key));
        return c;
    }

    private static boolean isOurSign(UUID packetSecret, String[] textLines) {
        if (packetSecret == null || textLines == null || textLines.length == 0) {
            return false;
        }
        String first = textLines[0];
        if (first == null) {
            return false;
        }
        try {
            return UUID.fromString(first).equals(packetSecret);
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Generated
    private SignUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static interface LineRenderer {
        public String render(String var1);
    }

    private static interface SupplierRenderer {
        public String render();
    }
}

