/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.util;

import com.deathmotion.totemguard.TotemGuard;
import io.github.retrooper.packetevents.util.SpigotReflectionUtil;
import io.github.retrooper.packetevents.util.folia.FoliaScheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class TpsUtil {
    private static TpsUtil instance;
    private final boolean isFolia = FoliaScheduler.isFolia();

    private TpsUtil() {
    }

    public static TpsUtil getInstance() {
        if (instance == null) {
            instance = new TpsUtil();
        }
        return instance;
    }

    public double getTps(Location location) {
        double rawTps;
        if (this.isFolia) {
            CompletableFuture future = new CompletableFuture();
            FoliaScheduler.getRegionScheduler().execute((Plugin)TotemGuard.getInstance(), location, () -> {
                try {
                    future.complete(Bukkit.getTPS()[0]);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            try {
                rawTps = (Double)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                rawTps = -1.0;
            }
        } else {
            rawTps = SpigotReflectionUtil.getTPS();
        }
        return Math.min(rawTps, 20.0);
    }
}

