/*
 * Decompiled with CFR 0.152.
 */
package com.deathmotion.totemguard.util;

import com.deathmotion.totemguard.TotemGuard;
import com.deathmotion.totemguard.api.versioning.TGVersion;
import com.deathmotion.totemguard.config.Settings;
import com.deathmotion.totemguard.util.TGVersions;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;

public class UpdateChecker {
    private final TotemGuard plugin;
    private final Settings settings;
    private boolean updateAvailable = false;
    @Nullable
    private TGVersion latestVersion;

    public UpdateChecker(TotemGuard plugin) {
        this.plugin = plugin;
        this.settings = plugin.getConfigManager().getSettings();
        if (this.settings.getUpdateChecker().isEnabled()) {
            this.checkForUpdate();
        }
    }

    public void checkForUpdate() {
        CompletableFuture.runAsync(() -> {
            try {
                TGVersion localVersion = TGVersions.CURRENT;
                this.latestVersion = this.fetchLatestGitHubVersion();
                if (this.latestVersion != null) {
                    this.handleVersionComparison(localVersion, this.latestVersion);
                } else {
                    this.plugin.getLogger().warning("Unable to fetch the latest version from GitHub.");
                }
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to check for updates: " + ex.getMessage());
            }
        });
    }

    private TGVersion fetchLatestGitHubVersion() {
        try {
            URLConnection connection = new URL("https://api.github.com/repos/Bram1903/TotemGuard/releases/latest").openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String jsonResponse = reader.readLine();
            reader.close();
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(jsonResponse, JsonObject.class);
            return TGVersion.fromString(jsonObject.get("tag_name").getAsString().replaceFirst("^[vV]", ""));
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to parse TotemGuard version! Version API: " + e.getMessage());
            return null;
        }
    }

    private void handleVersionComparison(TGVersion localVersion, TGVersion latestVersion) {
        if (localVersion.isOlderThan(latestVersion)) {
            this.notifyUpdateAvailable(localVersion, latestVersion);
        } else if (localVersion.isNewerThan(latestVersion)) {
            this.notifyOnDevBuild(localVersion, latestVersion);
        }
    }

    private void notifyUpdateAvailable(TGVersion currentVersion, TGVersion newVersion) {
        if (this.settings.getUpdateChecker().isPrintToConsole()) {
            this.plugin.getServer().getConsoleSender().sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[TotemGuard] ", (TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.text((String)"Update available! ", (TextColor)NamedTextColor.BLUE))).append((Component)Component.text((String)"Current version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)currentVersion.toString(), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" | New version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newVersion.toString(), (TextColor)NamedTextColor.DARK_PURPLE)));
        }
        this.updateAvailable = true;
    }

    private void notifyOnDevBuild(TGVersion currentVersion, TGVersion newVersion) {
        if (this.settings.getUpdateChecker().isPrintToConsole()) {
            this.plugin.getServer().getConsoleSender().sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[TotemGuard] ", (TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.text((String)"Development build detected. ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)"Current version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)currentVersion.toString(), (TextColor)NamedTextColor.AQUA))).append((Component)Component.text((String)" | Latest stable version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)newVersion.toString(), (TextColor)NamedTextColor.DARK_AQUA)));
        }
    }

    public Component getUpdateComponent() {
        return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Component.text((String)"[TotemGuard] ", (TextColor)NamedTextColor.RED).decoration(TextDecoration.BOLD, true))).append((Component)Component.text((String)("Version " + this.latestVersion.toString() + " is "), (TextColor)NamedTextColor.GREEN))).append(((TextComponent)((TextComponent)Component.text((String)"now available", (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.UNDERLINED)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to download", (TextColor)NamedTextColor.GREEN)))).clickEvent(ClickEvent.openUrl((String)"https://github.com/Bram1903/TotemGuard")))).append((Component)Component.text((String)"!", (TextColor)NamedTextColor.GREEN))).build();
    }

    @Generated
    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }
}

