package com.craftycorvid.improvedmaps;

import net.minecraft.class_1799;
import net.minecraft.class_9276;
import net.minecraft.class_9334;

public class ImprovedMapsUtils {
    public static String scaleToString(int scale) {
        switch (scale) {
            case 0:
                return "1:1";
            case 1:
                return "1:2";
            case 2:
                return "1:4";
            case 3:
                return "1:8";
            case 4:
                return "1:16";
            default:
                return "Unknown Scale";
        }
    }

    public static String formatDimensionString(String dimension) {
        switch (dimension) {
            case "minecraft:overworld":
                return "Overworld";
            case "minecraft:the_nether":
                return "The Nether";
            case "minecraft:the_end":
                return "The End";
            default:
                return dimension;
        }
    }

    public static class_1799 copyAtlas(class_1799 originalAtlas) {
        int originalAtlasFilledMapCount = originalAtlas
                .method_58695(class_9334.field_49650, class_9276.field_49289)
                .method_57426();
        int emptyMapCount =
                originalAtlas.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
        int newEmptyMapCount = Math.floorDiv(emptyMapCount - originalAtlasFilledMapCount, 2);
        if (newEmptyMapCount < 0) {
            return class_1799.field_8037;
        }
        class_1799 newAtlas = originalAtlas.method_46651(2);
        newAtlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, newEmptyMapCount);
        return newAtlas;
    }
}
