package com.craftycorvid.improvedmaps.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2497;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5536;
import net.minecraft.class_5537;
import net.minecraft.class_5630;
import net.minecraft.class_5631;
import net.minecraft.class_5632;
import net.minecraft.class_9209;
import net.minecraft.class_9276;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.apache.commons.lang3.math.Fraction;
import com.craftycorvid.improvedmaps.ImprovedMaps;
import com.craftycorvid.improvedmaps.ImprovedMapsComponentTypes;
import com.craftycorvid.improvedmaps.ImprovedMapsUtils;
import com.craftycorvid.improvedmaps.internal.ICustomBundleContentBuilder;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import xyz.nucleoid.packettweaker.PacketContext;

import static com.craftycorvid.improvedmaps.ImprovedMaps.id;

public class AtlasItem extends class_5537 implements PolymerItem {
    private static final int FULL_ITEM_BAR_COLOR = class_9848.method_61318(1.0F, 1.0F, 0.33F, 0.33F);
    private static final int ITEM_BAR_COLOR = class_9848.method_61318(1.0F, 0.44F, 0.53F, 1.0F);

    public AtlasItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        class_3222 player = context.getPlayer();
        if (player != null && player instanceof class_3222 && PolymerServerNetworking
                .getMetadata(player.field_13987, ImprovedMaps.HELLO_PACKET, class_2497.field_21037) != null)
            return this;
        else
            return itemStack.method_7947() > 1 ? class_1802.field_8529 : class_1802.field_27023;
    }

    @Override
    public class_2960 getPolymerItemModel(class_1799 itemStack, PacketContext context) {
        if (PolymerResourcePackUtils.hasMainPack(context)) {
            return id("atlas");
        } else {
            return class_2960.method_60655("minecraft", "book");
        }
    }

    @Override
    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType,
            PacketContext context) {
        class_1799 clientStack =
                PolymerItem.super.getPolymerItemStack(itemStack, tooltipType, context);

        String dimension = itemStack.method_58695(ImprovedMapsComponentTypes.ATLAS_DIMENSION, "");

        List<String> stringList = new ArrayList<>();
        stringList.add(dimension);

        clientStack.method_57379(class_9334.field_49637, new class_9280(
                new ArrayList<>(), new ArrayList<>(), stringList, new ArrayList<>()));
        return clientStack;
    }

    @Override
    public void modifyClientTooltip(List<class_2561> tooltip, class_1799 stack, PacketContext context) {
        String dimension = stack.method_58695(ImprovedMapsComponentTypes.ATLAS_DIMENSION, null);
        Byte scale = stack.method_58695(ImprovedMapsComponentTypes.ATLAS_SCALE, null);
        int filled_maps = stack
                .method_58695(class_9334.field_49650, class_9276.field_49289)
                .method_57426();
        Integer empty_maps =
                stack.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
        tooltip.clear();
        tooltip.add(class_2561.method_43470(filled_maps + "/512 Filled Maps").method_27692(class_124.field_1080));
        tooltip.add(class_2561.method_43470(empty_maps + " Empty Maps").method_27692(class_124.field_1080));
        if (dimension != null)
            tooltip.add(
                    class_2561.method_43470("Dimension " + ImprovedMapsUtils.formatDimensionString(dimension))
                            .method_27692(class_124.field_1080));
        if (scale != null)
            tooltip.add(class_2561.method_43470("Scale " + ImprovedMapsUtils.scaleToString(scale))
                    .method_27692(class_124.field_1080));
    }

    @Override
    public void method_7843(class_1799 stack, class_1937 world) {
        class_9276 bundleContents = stack
                .method_58695(class_9334.field_49650, class_9276.field_49289);
        class_1799 map = bundleContents.method_57422(0);
        class_9209 mapIdComponent = map.method_58694(class_9334.field_49646);
        class_22 activeState = class_1806.method_7997(mapIdComponent, world);
        if (activeState != null) {
            stack.method_57379(ImprovedMapsComponentTypes.ATLAS_SCALE, activeState.field_119);
            stack.method_57379(ImprovedMapsComponentTypes.ATLAS_DIMENSION,
                    activeState.field_118.method_29177().toString());
        }
        stack.method_57379(class_9334.field_49646, mapIdComponent);
    }

    @Override
    public boolean method_31565(class_1799 atlas, class_1735 slot, class_5536 clickType,
            class_1657 player) {
        if (atlas.method_7947() > 1)
            return false;

        class_9276 bundleContentsComponent =
                atlas.method_58694(class_9334.field_49650);
        if (bundleContentsComponent == null)
            return false;

        class_1799 itemStack = slot.method_7677();
        class_9276.class_9277 builder =
                new class_9276.class_9277(bundleContentsComponent);
        ((ICustomBundleContentBuilder) builder).setMaxSize(512);
        if (clickType == class_5536.field_27013 && !itemStack.method_7960()) {
            if (itemStack.method_31574(class_1802.field_8895)) {
                return handleEmptyMapCLick(atlas, itemStack, clickType);
            } else if (itemStack.method_31574(class_1802.field_8204)) {
                String dimension =
                        atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_DIMENSION, "");
                Byte scale = atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_SCALE, (byte) -1);
                class_22 mapState = class_1806.method_8001(itemStack, player.method_37908());

                if (mapState.field_119 != scale
                        || !mapState.field_118.method_29177().toString().equals(dimension))
                    return false;

                if (builder.method_57431(slot, player) > 0) {
                    method_38076(player);
                } else {
                    method_61641(player);
                }
                atlas.method_57379(class_9334.field_49650, builder.method_57435());
                this.method_64502(player);
                return true;
            }
        } else if (clickType == class_5536.field_27014 && itemStack.method_7960()) {
            atlas.method_57379(class_9334.field_49646, null);
            class_1799 itemStack2 = builder.method_57430();
            if (itemStack2 != null) {
                class_1799 itemStack3 = slot.method_32756(itemStack2);
                if (itemStack3.method_7947() > 0) {
                    builder.method_57432(itemStack3);
                } else {
                    method_38074(player);
                }
            }

            atlas.method_57379(class_9334.field_49650, builder.method_57435());
            this.method_64502(player);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_31566(class_1799 atlas, class_1799 otherStack, class_1735 slot, class_5536 clickType,
            class_1657 player, class_5630 cursorStackReference) {
        if (atlas.method_7947() > 1)
            return false;
        if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
            method_61637(atlas, -1);
            return false;
        }

        class_9276 bundleContentsComponent =
                atlas.method_58694(class_9334.field_49650);
        if (bundleContentsComponent == null)
            return false;

        class_9276.class_9277 builder =
                new class_9276.class_9277(bundleContentsComponent);
        ((ICustomBundleContentBuilder) builder).setMaxSize(512);
        if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
            if (otherStack.method_31574(class_1802.field_8895)) {
                return handleEmptyMapCLick(atlas, otherStack, clickType);
            } else if (otherStack.method_31574(class_1802.field_8204)) {
                String dimension =
                        atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_DIMENSION, null);
                Byte scale = atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_SCALE, (byte) 0);
                class_22 mapState = class_1806.method_8001(otherStack, player.method_37908());

                if (mapState.field_119 != scale
                        || !mapState.field_118.method_29177().toString().equals(dimension)) {
                    method_61641(player);
                    return false;
                }

                if (slot.method_32754(player) && builder.method_57432(otherStack) > 0) {
                    method_38076(player);
                } else {
                    method_61641(player);
                }

                atlas.method_57379(class_9334.field_49650, builder.method_57435());
                this.method_64502(player);
                return true;
            }
        } else if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            atlas.method_57379(class_9334.field_49646, null);
            if (slot.method_32754(player)) {
                class_1799 itemStack = builder.method_57430();
                if (itemStack != null) {
                    method_38074(player);
                    cursorStackReference.method_32332(itemStack);
                } else {
                    int emptyCount =
                            atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
                    if (emptyCount > 0) {
                        method_38074(player);
                        cursorStackReference.method_32332(new class_1799(class_1802.field_8895, emptyCount));
                        atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
                    }
                }
            }

            atlas.method_57379(class_9334.field_49650, builder.method_57435());
            this.method_64502(player);
            return true;
        }
        method_61637(atlas, -1);
        return false;
    }

    private boolean handleEmptyMapCLick(class_1799 atlas, class_1799 map, class_5536 clickType) {
        int emptyMapCount = atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
        int transferCount = clickType == class_5536.field_27014 ? 1 : map.method_7947();
        atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, emptyMapCount + transferCount);
        map.method_7934(transferCount);
        return true;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2680 blockState = context.method_8045().method_8320(context.method_8037());
        if (blockState.method_26164(class_3481.field_15501)) {
            class_1937 world = context.method_8045();
            if (!world.field_9236) {
                class_9209 mapIdComponent = context.method_8041().method_58694(class_9334.field_49646);
                class_22 mapState = world.method_17891(mapIdComponent);
                if (mapState != null
                        && !mapState.method_108(context.method_8045(), context.method_8037())) {
                    return class_1269.field_5814;
                }
            }

            return class_1269.field_5812;
        } else {
            return super.method_7884(context);
        }
    }

    // Disable onUse for AtlasItem
    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_1269.field_5811;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8952;
    }


    // Client-side rendering of the bundle fullness bar
    // Based on
    // https://github.com/FaeWulf/Diversity/blob/sub-mod-1.21.5/common-better-bundle/src/main/java/xyz/faewulf/diversity_better_bundle/mixin/item/buildingBundle/BundleItemMixin.java
    public static float method_31561(class_1799 stack) {
        int usedSpace = class_3532.method_59515(stack
                .method_58695(class_9334.field_49650, class_9276.field_49289)
                .method_57428(), 64);
        int maxValue = 512;

        return usedSpace * 1f / maxValue;
    }

    // override the weight value when pass the bundlecontens to the client side for rendering the
    // fullness bar
    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        Optional<class_5632> original = super.method_32346(stack);

        class_10712 tooltipdisplay = stack
                .method_58695(class_9334.field_56400, class_10712.field_56318);

        if (!tooltipdisplay.method_67214(class_9334.field_49650)) {
            return original;
        } else {
            int usedSpace = class_3532
                    .method_59515(stack.method_58695(class_9334.field_49650,
                            class_9276.field_49289).method_57428(), 64);
            int maxValue = 512;

            class_9276 bundleContents = stack.method_58695(
                    class_9334.field_49650, class_9276.field_49289);

            // override to List
            List<class_1799> itemStacks = new ArrayList<>();
            bundleContents.method_59707().forEach(itemStacks::add);

            // create new bundle content
            class_9276 bundleContents1 = new class_9276(itemStacks,
                    Fraction.getFraction(usedSpace * 1f / maxValue),
                    bundleContents.method_61668());

            // pass to client renderer
            return Optional.ofNullable(bundleContents1).map(class_5631::new);
        }
    }

    @Override
    public int method_31569(class_1799 stack) {
        int usedSpace = class_3532.method_59515(stack
                .method_58695(class_9334.field_49650, class_9276.field_49289)
                .method_57428(), 64);
        int maxValue = 512;

        return (int) Math.clamp(Math.floor(13f * usedSpace / maxValue), 1, 13);
    }

    @Override
    public int method_31571(class_1799 stack) {
        int usedSpace = class_3532.method_59515(stack
                .method_58695(class_9334.field_49650, class_9276.field_49289)
                .method_57428(), 64);
        int maxValue = 512;

        if (usedSpace >= maxValue) {
            return FULL_ITEM_BAR_COLOR;
        } else {
            return ITEM_BAR_COLOR;
        }
    }
}
