package com.craftycorvid.improvedmaps.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import com.craftycorvid.improvedmaps.ImprovedMapsComponentTypes;
import com.craftycorvid.improvedmaps.ImprovedMapsUtils;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2371;
import net.minecraft.class_3910;
import net.minecraft.class_3914;
import net.minecraft.class_3917;

@Mixin(class_3910.class)
public abstract class CartographyTableMixin extends class_1703 {
    protected CartographyTableMixin(class_3917<?> type, int syncId) {
        super(type, syncId);
    }

    @Shadow
    @Final
    private class_3914 context;

    @Shadow
    @Final
    private class_1731 resultInventory;

    @Shadow
    private void updateResult(class_1799 map, class_1799 item, class_1799 oldResult) {}

    @Inject(method = "onContentChanged", at = @At(value = "INVOKE",
            target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 0), cancellable = true)
    private void callUpdateResultOnSingleAtlas(class_1263 inventory, CallbackInfo ci,
            @Local(ordinal = 0) class_1799 itemStack, @Local(ordinal = 1) class_1799 itemStack2,
            @Local(ordinal = 2) class_1799 itemStack3) {
        if (itemStack.method_31574(ImprovedMapsItems.ATLAS)) {
            this.updateResult(itemStack, itemStack2, itemStack3);
            ci.cancel();
        }
    }

    @Inject(method = "updateResult", at = @At("HEAD"), cancellable = true)
    private void addAtlasInteractionsToUpdateResult(class_1799 map, class_1799 item,
            class_1799 oldResult, CallbackInfo ci) {
        if (map.method_31574(ImprovedMapsItems.ATLAS)) {
            this.context.method_17393((world, pos) -> {
                if (world.method_8608())
                    return;

                class_1799 newResult = null;

                if (map.method_31574(ImprovedMapsItems.ATLAS) && item.method_7960()) {
                    Integer empty_maps =
                            map.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
                    if (empty_maps > 0) {
                        newResult = new class_1799(class_1802.field_8895, empty_maps);
                        this.method_7623();
                    }
                } else if (map.method_31574(ImprovedMapsItems.ATLAS) && item.method_31574(class_1802.field_8529)) {
                    newResult = ImprovedMapsUtils.copyAtlas(map);
                    this.method_7623();
                }

                if (newResult != null && !class_1799.method_7973(newResult, oldResult)) {
                    this.resultInventory.method_5447(class_3910.field_30775,
                            newResult);
                    this.method_7623();
                }
            });

            ci.cancel();
        }
    }

    // to access the Cartography Table screen and its data in the ResultSlotMixin
    @Mixin(class_1703.class)
    public interface ScreenHandlerAccessor {
        @Accessor
        class_2371<class_1735> getSlots();
    }

    // target CartographyTableScreenHandler's second slot
    @Mixin(targets = "net/minecraft/screen/CartographyTableScreenHandler$4")
    public static abstract class SecondSlotMixin extends class_1735 {
        public SecondSlotMixin(class_1263 inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        @ModifyReturnValue(method = "canInsert", at = @At("RETURN"))
        private boolean canInsert(boolean original, class_1799 stack) {
            return original || stack.method_31574(class_1802.field_8529);
        }
    }

    // target CartographyTableScreenHandler's result slot
    @Mixin(targets = "net/minecraft/screen/CartographyTableScreenHandler$5")
    public static abstract class ResultSlotMixin extends class_1735 {
        public ResultSlotMixin(class_1263 inventory, int slot, int x, int y) {
            super(inventory, slot, x, y);
        }

        @Shadow
        @Final
        class_3910 field_17303;

        @Inject(method = "onTakeItem", at = @At("HEAD"), cancellable = true)
        public void onTakeItem(class_1657 player, class_1799 stack, CallbackInfo ci) {
            var slots = ((ScreenHandlerAccessor) field_17303).getSlots();
            var firstSlot = slots.get(0).method_7677();
            var secondSlot = slots.get(1).method_7677();

            if (firstSlot.method_31574(ImprovedMapsItems.ATLAS) && secondSlot.method_7960()) {
                firstSlot.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
                ci.cancel();
            }
        }
    }
}
