package com.craftycorvid.improvedmaps;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1852.class_1866;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import com.craftycorvid.improvedmaps.recipe.AtlasCopyRecipe;
import com.craftycorvid.improvedmaps.recipe.AtlasRecipe;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;

public final class ImprovedMaps implements ModInitializer {
	public static final String MOD_ID = "improved-maps";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
	public static final class_2960 HELLO_PACKET = id("hello");

	public static class_1866<AtlasRecipe> ATLAS_RECIPE_SERIALIZER;
	public static class_1866<AtlasCopyRecipe> ATLAS_COPY_RECIPE_SERIALIZER;

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	@Override
	public void onInitialize() {
		LOGGER.info("Improved Maps Initializing");

		ImprovedMapsNetworking.initialize();
		ImprovedMapsItems.initialize();
		ImprovedMapsComponentTypes.initialize();
		ImprovedMapsModifyVanillaItems.initialize();
		PolymerResourcePackUtils.addModAssets(MOD_ID);

		ATLAS_RECIPE_SERIALIZER = class_2378.method_10230(class_7923.field_41189,
				id("crafting_atlas"), new AtlasRecipe.Serializer(AtlasRecipe::new));
		ATLAS_COPY_RECIPE_SERIALIZER = class_2378.method_10230(class_7923.field_41189,
				id("copy_atlas"), new AtlasCopyRecipe.Serializer(AtlasCopyRecipe::new));
		ServerTickEvents.START_SERVER_TICK
				.register(ImprovedMapsLifecycleEvents::ImprovedMapsServerTick);
	}
}
