package com.craftycorvid.improvedmaps;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import com.craftycorvid.improvedmaps.internal.ICustomBundleContentBuilder;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_22;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

// Logic based on
// https://github.com/Pepperoni-Jabroni/MapAtlases/blob/main/src/main/java/pepjebs/mapatlases/lifecycle/MapAtlasesServerLifecycleEvents.java
public final class ImprovedMapsLifecycleEvents {
    // Used to prevent Map creation spam consuming all Empty Maps on auto-create
    private static final Semaphore mutex = new Semaphore(1);

    public static void ImprovedMapsServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player.method_31481() || player.method_14208() || player.method_14239())
                continue;
            class_1799 mainHand = player.method_5998(class_1268.field_5808);
            if (mainHand.method_31574(ImprovedMapsItems.ATLAS))
                AtlasPlayerHandTick(player, mainHand, class_1304.field_6173);
            class_1799 offHand = player.method_5998(class_1268.field_5810);
            if (offHand.method_31574(ImprovedMapsItems.ATLAS))
                AtlasPlayerHandTick(player, offHand, class_1304.field_6171);
        }
    }

    public static void initializeEmptyAtlas(class_3222 player, class_1799 atlas) {
        Boolean initialized = atlas.method_58694(ImprovedMapsComponentTypes.ATLAS_INITIALIZED);
        if (initialized == null || !initialized) {

            atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_INITIALIZED, true);

            class_9276 contents = atlas.method_58694(class_9334.field_49650);
            if (contents.method_57429()) {
                class_9276.class_9277 builder =
                        new class_9276.class_9277(class_9276.field_49289);
                ((ICustomBundleContentBuilder) builder).setMaxSize(512);

                int emptyCount = atlas.method_58694(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT);

                if (emptyCount > 0 || player.method_68878()) {
                    class_1799 newMap = class_1806.method_8005(player.method_51469(),
                            class_3532.method_15357(player.method_23317()), class_3532.method_15357(player.method_23321()),
                            atlas.method_58694(ImprovedMapsComponentTypes.ATLAS_SCALE), true, false);

                    builder.method_57432(newMap);
                    atlas.method_57379(class_9334.field_49650, builder.method_57435());

                    if (!player.method_68878()) {
                        atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, emptyCount - 1);
                    }
                }
            }
        }
    }

    public static void AtlasPlayerHandTick(class_3222 player, class_1799 atlas,
            class_1304 slot) {
        initializeEmptyAtlas(player, atlas);

        class_3218 world = player.method_51469();
        List<class_1799> currentDimMapItemStacks = getCurrentDimMapsFromAtlas(world, atlas);
        class_1799 mapStack = getActiveAtlasMap(currentDimMapItemStacks, player);
        if (mapStack == null)
            return;

        class_22 activeState = class_1806.method_8001(mapStack, world);
        // Create new Map entries
        if (isPlayerOutsideAllMapRegions(activeState, player)
                && atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_DIMENSION, "")
                        .equals(world.method_27983().method_29177().toString())) {
            class_1799 newMap = maybeCreateNewMapEntry(player, atlas, activeState,
                    class_3532.method_15357(player.method_23317()), class_3532.method_15357(player.method_23321()));
            if (newMap != null)
                mapStack = newMap;
        }

        if (mapStack.method_31574(class_1802.field_8204)) {
            atlas.method_57379(class_9334.field_49646, mapStack.method_58694(class_9334.field_49646));
            mapStack.method_7917(world, player, slot);
        }
    }

    private static boolean isPlayerOutsideAllMapRegions(class_22 activeState, class_1657 player) {
        byte scale = activeState.field_119;
        int scaleWidthFromCenter = ((1 << scale) * 64) + 8;
        return Math.abs(activeState.field_116 - player.method_23317()) > scaleWidthFromCenter
                || Math.abs(activeState.field_115 - player.method_23321()) > scaleWidthFromCenter;
    }

    public static List<class_1799> getAllMapsFromAtlas(class_3218 world, class_1799 atlas) {
        class_9276 bundleContents = atlas
                .method_58695(class_9334.field_49650, class_9276.field_49289);
        List<class_1799> mapStacks = new ArrayList<>();
        bundleContents.method_57421().forEach((map) -> {
            if (!map.method_7960() && map.method_31574(class_1802.field_8204))
                mapStacks.add(map);
        });
        return mapStacks;
    }

    public static List<class_1799> getCurrentDimMapsFromAtlas(class_3218 world, class_1799 atlas) {
        return getAllMapsFromAtlas(world, atlas).stream().filter(map -> {
            class_22 mapState = class_1806.method_8001(map, world);
            return mapState != null
                    ? mapState.field_118.method_29177()
                            .method_12833(world.method_27983().method_29177()) == 0
                    : false;
        }).toList();
    }

    public static class_1799 getActiveAtlasMap(List<class_1799> currentDimMapItemStacks,
            class_3222 player) {
        class_1799 minDistStack = null;
        for (class_1799 stack : currentDimMapItemStacks) {
            if (minDistStack == null) {
                minDistStack = stack;
                continue;
            }
            double previous = distanceBetweenMapStateAndPlayer(
                    class_1806.method_8001(minDistStack, player.method_51469()), player);
            double current = distanceBetweenMapStateAndPlayer(
                    class_1806.method_8001(stack, player.method_51469()), player);
            if (current < previous) {
                minDistStack = stack;
            }
        }
        return minDistStack;
    }

    public static double distanceBetweenMapStateAndPlayer(class_22 mapState, class_1657 player) {
        return Math.hypot(Math.abs(mapState.field_116 - player.method_23317()),
                Math.abs(mapState.field_115 - player.method_23321()));
    }

    private static class_1799 maybeCreateNewMapEntry(class_3222 player, class_1799 atlas,
            class_22 activeState, int playerX, int playerZ) {
        class_9276 bundleContents = atlas
                .method_58695(class_9334.field_49650, class_9276.field_49289);
        class_9276.class_9277 builder =
                new class_9276.class_9277(bundleContents);
        ((ICustomBundleContentBuilder) builder).setMaxSize(512);
        int emptyCount = atlas.method_58695(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);
        if (mutex.availablePermits() > 0 && (emptyCount > 0 || player.method_68878())) {
            try {
                mutex.acquire();
                byte scale = activeState.field_119;
                int currentX = activeState.field_116;
                int currentZ = activeState.field_115;
                int scaleWidth = (1 << scale) * 128;

                int newX = Math.abs(currentX - playerX) > (scaleWidth / 2)
                        ? currentX > playerX ? currentX - scaleWidth : currentX + scaleWidth
                        : currentX;
                int newZ = Math.abs(currentZ - playerZ) > (scaleWidth / 2)
                        ? currentZ > playerZ ? currentZ - scaleWidth : currentZ + scaleWidth
                        : currentZ;

                // Make the new map
                class_1799 newMap = class_1806.method_8005(player.method_51469(), newX, newZ,
                        (byte) scale, true, false);
                builder.method_57432(newMap);
                atlas.method_57379(class_9334.field_49650, builder.method_57435());
                if (!player.method_68878())
                    atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, emptyCount - 1);
                return newMap;
            } catch (InterruptedException e) {
                ImprovedMaps.LOGGER.warn(e.getMessage());
            } finally {
                mutex.release();
            }
        }
        return null;
    }
}
