package com.craftycorvid.improvedmaps;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import eu.pb4.polymer.networking.api.server.PolymerServerNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2497;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class ImprovedMapsNetworking {
    public static final Set<UUID> PLAYERS_WITH_CLIENT = new HashSet<>();

    public static void initialize() {
        ServerPlayConnectionEvents.JOIN.register(
                (class_3244 handler, PacketSender sender, MinecraftServer server) -> {
                    if (PolymerServerNetworking.getMetadata(handler, ImprovedMaps.HELLO_PACKET,
                            class_2497.field_21037) != null) {
                        PLAYERS_WITH_CLIENT.add(handler.method_32311().method_5667());
                    }
                });
        ServerPlayConnectionEvents.DISCONNECT
                .register((class_3244 handler, MinecraftServer server) -> {
                    PLAYERS_WITH_CLIENT.remove(handler.method_32311().method_5667());
                });
    }
}
